% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-methods.R
\name{ranef}
\alias{ranef}
\title{Extract random effects}
\usage{
ranef(object, ...)
}
\arguments{
\item{object}{A fitted model object.}

\item{...}{Additional arguments passed to methods.}
}
\value{
Method-specific; for \code{"brsmm"} objects, a matrix or named
  numeric vector of group-specific random-effect modes.
}
\description{
Generic function for extracting random effects.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
ranef(fit)
}

}
\seealso{
\code{\link{ranef.brsmm}}, \code{\link{brsmm_re_study}}
}
