% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-methods.R
\name{vcov.brsmm}
\alias{vcov.brsmm}
\title{Variance-covariance matrix for brsmm coefficients}
\usage{
\method{vcov}{brsmm}(object, model = c("full", "mean", "precision", "random"), ...)
}
\arguments{
\item{object}{A fitted \code{"brsmm"} object.}

\item{model}{Character: \code{"full"}, \code{"mean"},
\code{"precision"}, or \code{"random"}.}

\item{...}{Currently ignored.}
}
\value{
Numeric matrix.
}
\description{
Variance-covariance matrix for brsmm coefficients
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
vcov(fit, model = "mean")
}

}
\seealso{
\code{\link{brsmm}}, \code{\link{coef.brsmm}},
  \code{\link{confint.brsmm}}
}
