% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_predict.R
\name{simulate.bgmCompare}
\alias{simulate.bgmCompare}
\title{Simulate Data from a Fitted bgmCompare Model}
\usage{
\method{simulate}{bgmCompare}(
  object,
  nsim = 500,
  seed = NULL,
  group,
  method = c("posterior-mean"),
  iter = 1000,
  ...
)
}
\arguments{
\item{object}{An object of class \code{bgmCompare}.}

\item{nsim}{Number of observations to simulate. Default: \code{500}.}

\item{seed}{Optional random seed for reproducibility.}

\item{group}{Integer specifying which group to simulate from (1 to
number of groups). Required argument.}

\item{method}{Character string specifying which parameter estimates to use:
\describe{
  \item{\code{"posterior-mean"}}{Use posterior mean parameters (faster,
    single simulation).}
}}

\item{iter}{Number of Gibbs iterations for equilibration before collecting
samples. Default: \code{1000}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A matrix with \code{nsim} rows and \code{p} columns containing
  simulated observations for the specified group.
}
\description{
Generates new observations from the Markov Random Field model for a
specified group using the estimated parameters from a fitted
\code{bgmCompare} object.
}
\details{
Group-specific parameters are obtained by applying the projection matrix
to convert baseline parameters and differences into group-level estimates:
\code{group_param = baseline + projection[group, ] \%*\% differences}.

The function then uses these group-specific interaction and threshold
parameters to generate new data via Gibbs sampling.
}
\examples{
\donttest{
# Fit a comparison model
x <- Boredom[Boredom$language == "fr", 2:6]
y <- Boredom[Boredom$language != "fr", 2:6]
fit <- bgmCompare(x, y, chains = 2)

# Simulate 100 observations from group 1
new_data_g1 <- simulate(fit, nsim = 100, group = 1)

# Simulate 100 observations from group 2
new_data_g2 <- simulate(fit, nsim = 100, group = 2)
}

}
\seealso{
\code{\link{simulate.bgms}} for simulating from single-group models,
  \code{\link{predict.bgmCompare}} for computing conditional probabilities.
}
