% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{trim}
\alias{trim}
\title{Trim/Thin MCMC iterations}
\usage{
trim(object, burn = 500, thin = 10)
}
\arguments{
\item{object}{object from \code{bhetGP}, or \code{bhomGP}}

\item{burn}{integer specifying number of iterations to cut off as burn-in}

\item{thin}{integer specifying amount of thinning (\code{thin = 1} keeps all 
iterations, \code{thin = 2} keeps every other iteration, 
\code{thin = 10} keeps every tenth iteration, etc.)}
}
\value{
object of the same class with the selected iterations removed
}
\description{
Acts on a \code{bhetgp}, \code{bhetgp_vec}, \code{bhomgp}, or 
   \code{bhomgp_vec} object.
   Removes the specified number of MCMC iterations (starting at the first 
   iteration).  After these samples are removed, the remaining samples are
   optionally thinned.
}
\details{
The resulting object will have \code{nmcmc} equal to the previous 
    \code{nmcmc} minus \code{burn} divided by \code{thin}. Removing burn-ins 
    are necessary following convergence. Thinning is recommended as it can 
    eliminate highly correlated consecutive samples. Additionally, the size of
    the object reduces and ensures faster prediction.
}
