% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summary.mi_results}
\alias{summary.mi_results}
\title{Summary Method for Multiple Imputation Results}
\usage{
\method{summary}{mi_results}(object, ...)
}
\arguments{
\item{object}{A list containing multiple imputation results}

\item{...}{Additional arguments passed to print method}
}
\value{
No return value, called for side effects
}
\description{
Summary Method for Multiple Imputation Results
}
\examples{
# This example is not executed since it needs additional software (Apache Spark)
\dontrun{
# Example for mice.spark function
library(sparklyr)
library(dplyr)

# Connect to Spark
# Assumes that you have already installed Spark with sparklyr::spark_install()
sc <- spark_connect(master = "local")

# Create sample data with missing values
sample_data <- data.frame(
  outcome = c(1, 0, NA, 1, NA, 0),
  age = c(25, NA, 35, 28, 45, NA),
  income = c(50000, 60000, NA, 55000, 80000, 52000),
  education = c("High", "Medium", "High", NA, "Medium", "Medium")
)

# Copy to Spark DataFrame
sdf <- copy_to(sc, sample_data, "sample_data")

# Define variable types
variable_types <- c(
  outcome = "Binary",
  age = "Continuous_int",
  income = "Continuous_int",
  education = "Nominal"
)

# Define analysis formula
analysis_formula <- outcome ~ age + income + education

# Run MICE imputation
mice_result <- mice.spark(
  data = sdf,
  sc = sc,
  variable_types = variable_types,
  analysis_formula = analysis_formula,
  m = 3,  # Number of imputations
  maxit = 2,  # Number of iterations
  printFlag = TRUE,
  seed = 123,
  checkpointing = FALSE  # Set to TRUE if HDFS is available
)

# See results
summary(mice_result)
# Clean up
spark_disconnect(sc)
 }
}
