% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_analysis.R
\name{pls_vip}
\alias{pls_vip}
\title{Variable importance in projection (VIP) scores}
\usage{
pls_vip(object, comps = NULL)
}
\arguments{
\item{object}{A fitted PLS model.}

\item{comps}{Components used to compute the VIP scores. Defaults to all
available components.}
}
\value{
A named numeric vector of VIP scores.
}
\description{
Variable importance in projection (VIP) scores
}
\examples{
set.seed(123)
X <- matrix(rnorm(40), nrow = 10)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(10, sd = 0.1)
fit <- pls_fit(X, y, ncomp = 2, scores = "r")
pls_vip(fit)
}
