% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dol2.R
\name{dol2}
\alias{dol2}
\title{Generate efficient 2-Level Fractional Factorial Designs Using Beam Search}
\usage{
dol2(n, k, max_results = 20, beam_width = 3000, verbose = TRUE)
}
\arguments{
\item{n}{Integer. Total number of factors (base factors + generators).}

\item{k}{Integer. Number of dependent generator columns to add i.e. size of the fraction.
The resulting design has \code{r = n - k} base factors.}

\item{max_results}{Integer. Maximum number of final best-ranked designs
to return. Default is 20.}

\item{beam_width}{Integer. Maximum beam width used in beam search.
Default is 3000.}

\item{verbose}{Logical. If \code{TRUE}, prints detailed output for every
ranked design, including alias structure and blocked design. Default is TRUE.}
}
\value{
A list (invisible) of the best-ranked designs.
Each element contains:
\itemize{
  \item \code{generators_str}: Defining contrast used for generation of design,
  \item \code{design}: final design matrix with renamed factor labels,
  \item \code{score}: proxy measures (K3, K4),
  \item \code{key}: canonical key used for uniqueness.
}
}
\description{
This function constructs efficient 2-level unblocked and blocked fractional factorial designs
using a beam–search–based generator selection algorithm.
It evaluates candidate generators using proxy criteria (K3, K4) and
returns the top-ranked designs along with generators, scores, alias
structure, and blocked designs.
}
\details{
The function automatically:
\itemize{
  \item enumerates all possible generator masks,
  \item performs canonical ordering to avoid duplicates,
  \item evaluates designs using moment-based proxy criteria,
  \item selects best designs based on beam search,
  \item prints clean summaries (rank, design matrix, aliasing, blocks),
  \item returns a structured list of final designs.
}


The function internally uses:
\itemize{
  \item binary encoding of columns for canonical keys,
  \item moment-based proxies K3 and K4,
  \item mask enumeration for generator creation,
  \item alias structure detection for main and 2-factor effects,
  \item automatic block generator selection (2-level).
}

The generated output provides experimenters with statistically efficient
two-level fractional factorial designs that are well suited for both industrial
and agricultural research. By reducing the total number of experimental runs
while preserving the ability to estimate key main effects and low-order
interactions, these designs offer a resource-efficient framework for screening
factors, optimizing processes, and evaluating system performance under practical
field or laboratory constraints.
}
\examples{
\donttest{
# Generate 2-level fractional factorial designs:
res <- dol2(n = 5, k = 2, max_results = 5, beam_width = 3000, verbose = TRUE)

# Access first ranked design
res[[1]]$design
res[[1]]$generators_str
}

}
\references{
Dash, S., Parsad, R. and Gupta, V. K. (2013).
Row–column Designs for 2^n factorial 2-Colour Microarray Experiments for
Estimation of Main Effects and Two-Factor Interactions with Orthogonal
Parameterization. *Agricultural Research*, 2(2), 172–182.

National Bureau of Standards (1957).
*Fractional Factorial Experiment Designs for Factors at Two Levels*.
Applied Mathematics Series 48. US Government Printing Office, Washington DC.
}
