% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dol3.R
\name{dol3}
\alias{dol3}
\title{Generate efficient 3-Level Fractional Factorial Designs Using Beam Search}
\usage{
dol3(
  n,
  k,
  max_results = 20,
  top_k_block = 3,
  beam_width = 3000,
  verbose = TRUE,
  time_limit = 600
)
}
\arguments{
\item{n}{Integer. Total number of factors (base + generated).}

\item{k}{Integer. Number of dependent generator columns to add i.e. size of fraction.
The number of base factors is \code{r = n - k}.}

\item{max_results}{Integer. Maximum number of final best-ranked designs
returned. Default: \code{20}.}

\item{top_k_block}{Integer. Number of top block generators to consider when
automatically selecting block structures. Default: \code{3}.}

\item{beam_width}{Integer. Maximum beam width used during the beam search.
Default: \code{3000}.}

\item{verbose}{Logical. If \code{TRUE}, prints ranked designs, WL patterns,
alias structures, and blocked designs. Default: \code{TRUE}.}

\item{time_limit}{Numeric. Maximum elapsed time (seconds) allowed for the
beam-search expansion. Default: \code{600}.}
}
\value{
A list (invisible) of the best-ranked 3-level fractional factorial
designs.

Each list element contains:
\itemize{
  \item \code{generators}: list of generator coefficient vectors,
  \item \code{generators_str}: Defining contrast expressions,
  \item \code{design}: final design matrix with renamed factor levels,
  \item \code{A}: word-length pattern \eqn{(A_3, A_4, A_5, A_6)}.
}

When \code{verbose = TRUE}, the function additionally prints:
\itemize{
  \item canonical generator expressions,
  \item design matrix,
  \item alias structure (main, 2-factor interactions),
  \item automatically generated blocked design with confounding summary.
}
}
\description{
This function constructs efficient 3-level unblocked and blocked fractional factorial designs
using an iterative beam-search generator selection algorithm.
}
\details{
It evaluates candidate generators using moment-based proxy criteria
(\eqn{A_3}, \eqn{A_4}, \eqn{A_5}, \eqn{A_6}) and returns the best-ranked
designs along with:
\itemize{
  \item generator coefficient vectors,
  \item canonical ternary design keys,
  \item full design matrices,
  \item word-length patterns,
  \item alias structure (main + 2-factor),
  \item automatically determined block structures.
}

This is the 3-level analogue of \code{dol2()}, supporting generation of
3-level fractional factorial design generation.


Internally, \code{dol3()} performs:
\itemize{
  \item ternary (0/1/2) grid generation for base factors,
  \item dynamic enumeration of canonical generator coefficient vectors,
  \item computation of moment based K statistics and \eqn{A_3-A_6},
  \item canonical design key generation to avoid duplication,
  \item beam-search pruning with user-specified width,
  \item automatic selection of efficient 3-level block generators.
}

The generated designs are well suited for industrial, agricultural, and
scientific investigations that demand high-resolution three-level fractional
factorial structures with optional blocking. These designs efficiently
accommodate multi-level factors, enable precise estimation of main effects
and critical interaction terms, and offer flexibility for managing heterogeneity
through block formation. As a result, they provide a robust and resource-efficient
framework for complex experimental systems conducted in field or laboratory settings.
}
\examples{
\donttest{
# Generate a 3-level fractional factorial design:
res3 <- dol3(n = 5, k = 2, max_results = 3, verbose = TRUE)

# View the best-ranked design:
res3[[1]]$design
res3[[1]]$generators_str
res3[[1]]$A   # Word length pattern A3-A6
}

}
\references{
Xu, H. (2005).
A catalogue of three-level regular fractional factorial designs.
*Metrika*, 62, 259-281.
}
