% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_weiterbildungssuche.R
\name{weiterbildungssuche_search}
\alias{weiterbildungssuche_search}
\title{Search continuing education courses}
\usage{
weiterbildungssuche_search(
  sw = NULL,
  orte = NULL,
  uk = NULL,
  page = NULL,
  params = list(),
  safe = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{sw}{Search keyword.}

\item{orte}{Location with coordinates (format: "City_lat_lon").}

\item{uk}{Search radius in km (25, 50, 100, 150, 200, or "bundesweit").}

\item{page}{Result page number.}

\item{params}{Additional query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with course offerings.
}
\description{
Search continuing education courses
}
\details{
The Weiterbildungssuche API provides access to one of Germany's largest
continuing education databases from the Bundesagentur fuer Arbeit.
Authentication uses the public client id \code{infosysbub-wbsuche} as X-API-Key.
Official docs: https://bundesapi.github.io/weiterbildungssuche-api/.

Common parameters include:
\itemize{
\item \code{sys}: C = vocational, FW = advanced, empty = both
\item \code{uz}: 1 = full-time, 2 = part-time
\item \code{uf}: 1 = in-person, 2 = online, 3 = blended, 4 = distance
\item \code{bg}: 1 = education voucher eligible
}
}
\examples{
\dontrun{
weiterbildungssuche_search(sw = "Projektmanagement")
weiterbildungssuche_search(sw = "IT", orte = "Berlin_52.52_13.405", uk = 50)
}

}
\seealso{
\code{\link[=weiterbildungssuche_facetten]{weiterbildungssuche_facetten()}} for faceted search overview.
}
