% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_dwd.R
\name{dwd_crowd_reports}
\alias{dwd_crowd_reports}
\title{Fetch DWD crowd reports}
\usage{
dwd_crowd_reports(
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with crowd reports.

Includes \code{timestamp_time} as POSIXct in Europe/Berlin.
}
\description{
Fetch DWD crowd reports
}
\details{
Retrieves crowd-sourced weather reports from the DWD App API.
Official docs: https://dwd.api.bund.dev.
}
\examples{
\dontrun{
dwd_crowd_reports(flatten = TRUE)
}

}
\seealso{
\code{\link[=dwd_station_overview]{dwd_station_overview()}} and \code{\link[=dwd_warnings_nowcast]{dwd_warnings_nowcast()}}.
}
