% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{axe-function}
\alias{axe-function}
\alias{axe_env.function}
\title{Axing functions.}
\usage{
\method{axe_env}{`function`}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed function.
}
\description{
Functions stored in model objects often have heavy environments
and bytecode attached. To avoid breaking any post-estimation functions
on the model object, the \code{butchered_function} class is not
appended.
}
\examples{
\dontshow{if (rlang::is_installed("caret")) withAutoprint(\{ # examplesIf}
# Load libraries
library(caret)

data(iris)
train_data <- iris[, 1:4]
train_classes <- iris[, 5]

train_fit <- train(train_data, train_classes,
                   method = "knn",
                   preProcess = c("center", "scale"),
                   tuneLength = 10,
                   trControl = trainControl(method = "cv"))

out <- axe_env(train_fit$modelInfo$prob, verbose = TRUE)
out <- axe_env(train_fit$modelInfo$levels, verbose = TRUE)
out <- axe_env(train_fit$modelInfo$predict, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
