% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabnet_fit.R
\name{axe-tabnet_fit}
\alias{axe-tabnet_fit}
\alias{axe_fitted._tabnet_fit}
\title{Axing a tabnet_fit.}
\usage{
\method{axe_fitted}{`_tabnet_fit`}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed tabnet_fit object.
}
\description{
Axing a tabnet_fit.

Remove fitted values.
}
\examples{
\dontshow{if (rlang::is_installed("tabnet")) withAutoprint(\{ # examplesIf}

# Load libraries
suppressWarnings(suppressMessages(library(parsnip)))
suppressWarnings(suppressMessages(library(rsample)))
suppressWarnings(suppressMessages(library(tabnet)))

# Load data
split <- initial_split(mtcars, prop = 9/10)
car_train <- training(split)


if (interactive() & torch::torch_is_installed()) {
  torch::torch_manual_seed(1)

  # Create model and fit
  mtcar_fit <- tabnet::tabnet() |>
  set_mode("regression") |>
  set_engine("torch") |>
  fit(mpg ~ ., data = car_train)

  out <- butcher(mtcar_fit, verbose = TRUE)
}
\dontshow{\}) # examplesIf}
}
