% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgb.R
\name{axe-xgb.Booster}
\alias{axe-xgb.Booster}
\alias{axe_call.xgb.Booster}
\alias{axe_env.xgb.Booster}
\title{Axing a xgb.Booster.}
\usage{
\method{axe_call}{xgb.Booster}(x, verbose = FALSE, ...)

\method{axe_env}{xgb.Booster}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed xgb.Booster object.
}
\description{
xgb.Booster objects are created from the \pkg{xgboost} package,
which provides efficient and scalable implementations of gradient
boosted decision trees. Given the reliance of post processing
functions on the model object, like \code{xgb.Booster.complete},
on the first class listed, the \code{butcher_xgb.Booster} class is
not appended.
}
\examples{
\dontshow{if (rlang::is_installed(c("parsnip", "xgboost"))) withAutoprint(\{ # examplesIf}
library(xgboost)
library(parsnip)

data(agaricus.train)

if (utils::packageVersion("xgboost") > "2.0.0.0") {
  bst <- xgboost(x = agaricus.train$data,
                 y = as.factor(agaricus.train$label),
                 learning_rate = 1,
                 nthread = 2,
                 nrounds = 2,
                 eval_metric = "logloss",
                 objective = "binary:logistic")
} else {
  bst <- xgboost(data = agaricus.train$data,
                 label = agaricus.train$label,
                 eta = 1,
                 nthread = 2,
                 nrounds = 2,
                 eval_metric = "logloss",
                 objective = "binary:logistic",
                 verbose = 0)
}

out <- butcher(bst, verbose = TRUE)

# Another xgboost model
fit <- boost_tree(mode = "classification", trees = 20) |>
  set_engine("xgboost", eval_metric = "mlogloss") |>
  fit(Species ~ ., data = iris)

out <- butcher(fit, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
