% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalClusterQuality.R
\encoding{UTF-8}
\name{homogeneity}
\alias{homogeneity}
\title{Calculate within-cluster homogeneity}
\usage{
homogeneity(X, oneI = FALSE, oneM = FALSE)
}
\arguments{
\item{X}{three-way array; the \eqn{I \times J \times M} array has \eqn{I}
assessors, \eqn{J} products, \eqn{M} attributes where CATA data have values 
\code{0} (not checked) and \code{1} (checked)}

\item{oneI}{indicates whether calculation is for one assessor (default: 
\code{FALSE})}

\item{oneM}{indicates whether calculation is for one attribute (default: 
\code{FALSE})}
}
\value{
homogeneity index
}
\description{
Within a group of \code{N} consumers, the Homogeneity index lies between
\code{1/N} (no homogeneity) to \code{1} (perfect homogeneity).
}
\examples{
# homogeneity index for the first 7 consumers on the first 6 attributes
homogeneity(bread$cata[1:7,,1:6])
}
\references{
Llobell, F., Cariou, V., Vigneau, E., Labenne, A., & Qannari, 
E.M. (2019). A new approach for the analysis of data and the clustering of  
subjects in a CATA experiment. \emph{Food Quality and Preference}, 72, 31-39, 
\doi{10.1016/j.foodqual.2018.09.006}
}
