% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{exogenize}
\alias{exogenize}
\title{Exogenize a graph}
\usage{
exogenize(cg, nodes)
}
\arguments{
\item{cg}{A \code{caugi} object of class \code{"DAG"}.}

\item{nodes}{A character vector of node names to exogenize. Must be a subset
of the nodes in the graph.}
}
\value{
A \code{caugi} object representing the exogenized graph.
}
\description{
Exogenize a graph by removing all ingoing edges to the set of nodes
specified (i.e., make the nodes exogenous), as well as joining the
parents of the nodes specified to the children of the nodes specified.
}
\examples{
cg <- caugi(A \%-->\% B, class = "DAG")
exogenize(cg, nodes = "B") # A, B

}
\seealso{
Other operations: 
\code{\link{condition_marginalize}()},
\code{\link{latent_project}()},
\code{\link{moralize}()},
\code{\link{mutate_caugi}()},
\code{\link{skeleton}()}
}
\concept{operations}
