% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spillover_heatmap.R
\name{spillover_heatmap}
\alias{spillover_heatmap}
\title{Spillover heatmap}
\usage{
spillover_heatmap(
  x,
  text = NULL,
  cutoff = 0.5,
  fontsize = 8,
  subset = NULL,
  ...
)
}
\arguments{
\item{x}{Either a 'cellMarkers' or 'deconv' class object or a spillover
matrix.}

\item{text}{Logical whether to show values of cells where spillover >
\code{cutoff}. By default only shown for smaller matrices.}

\item{cutoff}{Threshold for showing values.}

\item{fontsize}{Numeric value for font size for cell values when
\code{text = TRUE}.}

\item{subset}{Character vector of groups to be subsetted.}

\item{...}{Optional arguments passed to \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}.}
}
\value{
No return value. Draws a heatmap using ComplexHeatmap.
}
\description{
Produces a heatmap from a 'cellMarkers' or 'deconv' class object showing
estimated amount of spillover between cell subclasses. The amount that each
cell subclass's overall vector spillovers (projects) into other cell
subclasses' vectors is shown in each row. Thus the column gives an estimate
of how much the most influential (specific) genes for a cell subclass are
expressed in other cells.
}
