% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circle-package.R
\docType{package}
\name{circle-package}
\alias{circle-package}
\title{Circle CI API Client}
\description{
This package provides functionality for interacting with the
Circle CI API. \href{https://circleci.com}{Circle CI} is a continuous
integration provider which allows for
automated testing of software each time that software is publicly committed
to a repository on GitHub.

This package interacts with the Circle CI REST API and allows to execute
tasks in R without visiting the the website. This includes monitoring
builds, modifying build environment settings and environment variables, and
cancelling or restarting builds.

Use of this package requires a Circle API key. Unless a key is already set,
users will be guided through the creation of a key,
API keys are disposable, but should still be treated securely.

The following functions simplify integrating R package testing and
deployment with GitHub and Circle CI:
\itemize{
\item \code{\link[=enable_repo]{enable_repo()}} enables Circle CI for your repository,
\item \code{\link[=use_circle_deploy]{use_circle_deploy()}} installs a public deploy key on GitHub and the
corresponding private key on Circle CI to simplify deployments to GitHub
from Circle CI.
}
}
\examples{
\dontrun{
# check to see if you've authenticated correctly
get_circle_user()
}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/circle/}
  \item \url{https://github.com/ropensci/circle}
  \item Report bugs at \url{https://github.com/ropensci/circle/issues}
}

}
\author{
\strong{Maintainer}: Patrick Schratz \email{patrick.schratz@gmail.com} (\href{https://orcid.org/0000-0003-0748-6624}{ORCID})

Other contributors:
\itemize{
  \item Max Joseph (Max reviewed the package for ropensci, see <https://github.com/ropensci/software-review/issues/356>) [reviewer]
  \item Sharla Gelfand (Sharla reviewed the package for ropensci, see <https://github.com/ropensci/software-review/issues/356>) [reviewer]
}

}
