% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmat.R
\name{dmat}
\alias{dmat}
\title{Spline derivative matrix}
\usage{
dmat(d, s, knots, ord)
}
\arguments{
\item{d}{Non-negative integer giving the order of derivation. Should be between 0 and \code{ord - 2}.}

\item{s}{Sign of the derivative.}

\item{knots}{Vector of ordered knots from the spline bases.}

\item{ord}{Non-negative integer giving the order of the spline.}
}
\value{
A matrix of weighted differences that can be used to constrain B-spline bases.
}
\description{
Computes a derivative matrix for B-splines that can then be used for shape-constraints. It is internally called by \link[=shapeConstr]{shapeConstr} and should not be used directly.
}
\details{
Does the heavy lifting in \link[=shapeConstr]{shapeConstr} to create a constraint matrix for shape-constrained B-splines. Only useful for advanced users to create constraint matrices without passing an object to one of the \link[=shapeConstr]{shapeConstr} methods.
}
\note{
\code{dmat} doesn't perform any checks of the parameters so use carefully. In normal usage, checks are done by \link[=shapeConstr]{shapeConstr} methods.
}
\examples{
# A second derivative matrix for cubic B-Splines with regularly spaced knots
# Can be used to enforce convexity
cirls:::dmat(2, 1, 1:15, 4)

}
