\name{audit_c_alcohol_screen}
\alias{audit_c_alcohol_screen}
\title{
AUDIT-C Alcohol Use Screen
}
\description{
Calculates the AUDIT-C (Alcohol Use Disorders Identification Test - Consumption) score. This is a 3-item screening tool derived from the full AUDIT to identify patients with hazardous alcohol consumption or active alcohol use disorders.
}
\usage{
audit_c_alcohol_screen(sex, frequency_score, amount_score, binge_score)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female"). Cutoffs differ by sex (Male >= 4, Female >= 3).
}
  \item{frequency_score}{
Numeric (0-4). "How often do you have a drink containing alcohol?"
0: Never.
1: Monthly or less.
2: 2-4 times a month.
3: 2-3 times a week.
4: 4 or more times a week.
}
  \item{amount_score}{
Numeric (0-4). "How many standard drinks containing alcohol do you have on a typical day?"
0: 1 or 2.
1: 3 or 4.
2: 5 or 6.
3: 7 to 9.
4: 10 or more.
}
  \item{binge_score}{
Numeric (0-4). "How often do you have six or more drinks on one occasion?"
0: Never.
1: Less than monthly.
2: Monthly.
3: Weekly.
4: Daily or almost daily.
}
}
\value{
A list containing:
\item{AUDIT_C_Score}{The calculated total score (Range 0-12).}
\item{Screen_Result}{"Positive Screen" or "Negative Screen".}
\item{Interpretation}{Clinical guidance based on the score.}
}
\references{
Bush K, Kivlahan DR, McDonell MB, Fihn SD, Bradley KA. The AUDIT alcohol consumption questions (AUDIT-C): an effective brief screening test for problem drinking. Ambulatory Care Quality Improvement Project (ACQUIP). Alcohol Use Disorders Identification Test. Arch Intern Med. 1998;158(16):1789-1795. doi:10.1001/archinte.158.16.1789
}
\examples{

# Example 1: Positive Screen (Male)
# Frequent drinking (3), Moderate amount (1), Occasional binge (2)
# Score = 6
audit_c_alcohol_screen("male", 3, 1, 2)

# Example 2: Negative Screen (Female)
# Monthly drinking (1), Low amount (0), No binge (0)
# Score = 1
audit_c_alcohol_screen("female", 1, 0, 0)
}
