\name{bacterial_meningitis_score}
\alias{bacterial_meningitis_score}
\title{
Bacterial Meningitis Score for Children
}
\description{
Calculates the Bacterial Meningitis Score to stratify the risk of bacterial meningitis in children (aged 29 days to 19 years) presenting with CSF pleocytosis (>= 10 WBCs/uL). A score of 0 identifies patients at very low risk who may be candidates for outpatient management.
}
\usage{
bacterial_meningitis_score(gram_stain_positive, csf_protein_mg_dl,
                           peripheral_anc, seizure_history, csf_neutrophils)
}
\arguments{
  \item{gram_stain_positive}{
Numeric (0 or 1). Is the CSF Gram stain positive for bacteria? (1 = Yes, +2 points).
}
  \item{csf_protein_mg_dl}{
Numeric. CSF protein level in mg/dL. (>= 80 mg/dL adds +1 point).
}
  \item{peripheral_anc}{
Numeric. Peripheral blood Absolute Neutrophil Count (cells/mm3). (>= 10,000 cells/mm3 adds +1 point).
}
  \item{seizure_history}{
Numeric (0 or 1). Seizure at or prior to presentation? (1 = Yes, +1 point).
}
  \item{csf_neutrophils}{
Numeric. CSF Absolute Neutrophil Count (cells/mm3). (>= 1,000 cells/mm3 adds +1 point).
}
}
\value{
A list containing:
\item{BMS_Score}{The calculated Bacterial Meningitis Score (Range 0-6).}
\item{Risk_Category}{"Very Low Risk" (Score 0) or "Not Low Risk" (Score >= 1).}
\item{Interpretation}{Clinical guidance based on the score.}
}
\references{
Nigrovic LE, Kuppermann N, Malley R. Development and validation of a multivariable predictive model to distinguish bacterial from aseptic meningitis in children in the post-Haemophilus influenzae era. Pediatrics. 2002;110(4):712-719. doi:10.1542/peds.110.4.712
}
\examples{

# Example 1: High Risk
# Positive Gram stain (+2), Protein 90 (+1), ANC 12000 (+1)
# Score = 4
bacterial_meningitis_score(1, 90, 12000, 0, 500)

# Example 2: Very Low Risk
# Negative Gram stain, Protein 40, ANC 5000, No seizure, CSF Neuts 100
# Score = 0
bacterial_meningitis_score(0, 40, 5000, 0, 100)
}
