\name{binet_staging_cll}
\alias{binet_staging_cll}
\title{
Binet Staging System for Chronic Lymphocytic Leukemia (CLL)
}
\description{
Classifies Chronic Lymphocytic Leukemia (CLL) into three prognostic stages (A, B, or C) based on the number of involved lymphoid areas and the presence of anemia or thrombocytopenia.
}
\usage{
binet_staging_cll(hemoglobin_g_dl, platelets_per_ul, cervical_nodes,
                  axillary_nodes, inguinal_nodes, liver_spleen_palpable)
}
\arguments{
  \item{hemoglobin_g_dl}{
Numeric. Hemoglobin level in g/dL. (Threshold < 10 g/dL).
}
  \item{platelets_per_ul}{
Numeric. Platelet count. (Threshold < 100,000/uL).
}
  \item{cervical_nodes}{
Numeric (0 or 1). Enlargement of cervical lymph nodes. (1 = Yes).
}
  \item{axillary_nodes}{
Numeric (0 or 1). Enlargement of axillary lymph nodes. (1 = Yes).
}
  \item{inguinal_nodes}{
Numeric (0 or 1). Enlargement of inguinal lymph nodes. (1 = Yes).
}
  \item{liver_spleen_palpable}{
Numeric (0 or 1). Palpable hepatomegaly or splenomegaly. (1 = Yes).
}
}
\value{
A list containing:
\item{Binet_Stage}{The calculated stage (A, B, or C).}
\item{Criteria_Description}{Description of the specific criteria met.}
\item{Median_Survival}{Estimated median survival based on historical data.}
}
\references{
Binet JL, Auquier A, Dighiero G, et al. A new prognostic classification of chronic lymphocytic leukemia derived from a multivariate survival analysis. Cancer. 1981;48(1):198-206. doi:10.1002/1097-0142(19810701)48:1<198::aid-cncr2820480131>3.0.co;2-v
}
\examples{

# Example 1: Stage C
# Hb 9.0 (Anemia), Plt 150k, 1 area involved
binet_staging_cll(9.0, 150000, 1, 0, 0, 0)

# Example 2: Stage A
# Hb 14, Plt 200k, 1 area involved (Cervical)
binet_staging_cll(14, 200000, 1, 0, 0, 0)

# Example 3: Stage B
# Hb 13, Plt 180k, 3 areas involved (Cervical, Axillary, Spleen)
binet_staging_cll(13, 180000, 1, 1, 0, 1)
}
