\name{brescia_covid_severity}
\alias{brescia_covid_severity}
\title{
Brescia-COVID Respiratory Severity Scale (BCRSS)
}
\description{
Implements the Brescia-COVID Respiratory Severity Scale Algorithm. This stepwise approach helps triage COVID-19 patients based on respiratory symptoms, oxygenation status, and chest imaging to determine the appropriate level of respiratory support (Observation, O2, or NIV/Intubation).
}
\usage{
brescia_covid_severity(wheezing_present, rr_gt_22_or_desat,
                       worsening_cxr_or_unstable)
}
\arguments{
  \item{wheezing_present}{
Numeric (0 or 1). Is wheezing present on auscultation? (1 = Yes - suggests Asthma/COPD pathway).
}
  \item{rr_gt_22_or_desat}{
Numeric (0 or 1). Is Respiratory Rate > 22 bpm OR SpO2 < 90\% on room air? (1 = Yes).
}
  \item{worsening_cxr_or_unstable}{
Numeric (0 or 1). Despite supplemental oxygen, is SpO2 < 90\% OR is there significant worsening on Chest X-ray? (1 = Yes).
}
}
\value{
A list containing:
\item{BCRSS_Severity_Level}{The calculated severity tier (0-3).}
\item{Management_Recommendation}{Clinical guidance for respiratory support escalation.}
}
\references{
Piva S, Filippini M, Turla F, et al. Clinical presentation and initial management of COVID-19 patients in Brescia, Italy. Anaesthesia. 2020.
}
\examples{

# Example 1: High Severity (Need NIV/ICU)
# No wheeze, Tachypneic, Worsening despite O2
brescia_covid_severity(0, 1, 1)

# Example 2: Mild/Observation
# No wheeze, Normal RR/SpO2
brescia_covid_severity(0, 0, 0)
}
