\name{cedocs_score}
\alias{cedocs_score}
\title{
CEDOCS Score for Emergency Department Overcrowding
}
\description{
Calculates the Community Emergency Department Overcrowding Scale (CEDOCS) score. This tool estimates the severity of overcrowding in community emergency departments (EDs) using operational variables such as patient census, waiting times, and annual volume. It is derived from the NEDOCS tool but calibrated for community hospital settings.
}
\usage{
cedocs_score(critical_care_patients, longest_admit_wait_hours,
             waiting_room_patients, total_ed_patients, ed_beds, annual_visits)
}
\arguments{
  \item{critical_care_patients}{
Numeric. Number of critical care patients currently in the ED.
}
  \item{longest_admit_wait_hours}{
Numeric. The longest time (in hours) any currently admitted patient has been waiting in the ED for a hospital bed.
}
  \item{waiting_room_patients}{
Numeric. Number of patients currently in the ED waiting room.
}
  \item{total_ed_patients}{
Numeric. Total number of patients currently in the ED (including those in beds, hallways, and waiting room).
}
  \item{ed_beds}{
Numeric. Total licensed number of ED treatment beds.
}
  \item{annual_visits}{
Numeric. The total number of ED visits per year (annual census).
}
}
\value{
A list containing:
\item{CEDOCS_Score}{The calculated score (Range 0-200).}
\item{Level_of_Crowding}{Interpretation of the score:
0-20: Not Busy
21-60: Busy
61-100: Extremely Busy but Not Overcrowded
101-140: Overcrowded
141-180: Severely Overcrowded
181-200: Dangerously Overcrowded}
}
\references{
Weiss SJ, Derlet R, Arndahl J, et al. Estimating the degree of emergency department overcrowding in academic medical centers: results of the National ED Overcrowding Study (NEDOCS). Acad Emerg Med. 2004;11(1):38-50.
Weiss SJ, Ernst AA, Nick TG. Identifying and comparing the crowds in emergency departments.
}
\examples{

# Example 1: Busy ED
# 2 critical, 4 hour wait, 10 in waiting room, 25 total patients, 20 beds, 35k visits
cedocs_score(2, 4, 10, 25, 20, 35000)

# Example 2: Overcrowded ED
# 5 critical, 8 hour wait, 25 in waiting room, 50 total patients, 30 beds, 50k visits
cedocs_score(5, 8, 25, 50, 30, 50000)
}
