\name{check_tpa_contraindications}
\alias{check_tpa_contraindications}
\title{
tPA Contraindications for Ischemic Stroke
}
\description{
Evaluates a patient for contraindications to intravenous tissue plasminogen activator (tPA) therapy for acute ischemic stroke. This function checks standard exclusion criteria based on AHA/ASA guidelines, including timing, history of hemorrhage, recent surgery/trauma, severe hypertension, and coagulopathy.
}
\usage{
check_tpa_contraindications(symptom_duration_hours, age, disability_status, ich_history,
                            intracranial_neoplasm_avm_aneurysm,
                            recent_intracranial_spinal_surgery, active_internal_bleeding,
                            suspected_aortic_dissection, severe_uncontrolled_hypertension,
                            recent_stroke, recent_head_trauma, current_anticoagulant_use,
                            platelet_count, inr, aptt, pt, glucose)
}
\arguments{
  \item{symptom_duration_hours}{
Numeric. Time from onset of symptoms (or last known normal) in hours. (> 4.5 hours is a contraindication).
}
  \item{age}{
Numeric. Patient age in years. (Age > 80 is a relative contraindication in the 3-4.5h window).
}
  \item{disability_status}{
Numeric (0 or 1). Severe disability prior to stroke (mRS > 1). (Often a relative contraindication).
}
  \item{ich_history}{
Numeric (0 or 1). History of intracranial hemorrhage. (1 = Yes).
}
  \item{intracranial_neoplasm_avm_aneurysm}{
Numeric (0 or 1). Presence of intracranial neoplasm, arteriovenous malformation, or aneurysm. (1 = Yes).
}
  \item{recent_intracranial_spinal_surgery}{
Numeric (0 or 1). Recent intracranial or spinal surgery (within 3 months). (1 = Yes).
}
  \item{active_internal_bleeding}{
Numeric (0 or 1). Active internal bleeding. (1 = Yes).
}
  \item{suspected_aortic_dissection}{
Numeric (0 or 1). Clinical suspicion of aortic dissection. (1 = Yes).
}
  \item{severe_uncontrolled_hypertension}{
Numeric (0 or 1). Severe uncontrolled hypertension (SBP > 185 or DBP > 110) unresponsive to treatment. (1 = Yes).
}
  \item{recent_stroke}{
Numeric (0 or 1). Recent ischemic stroke (within 3 months). (1 = Yes).
}
  \item{recent_head_trauma}{
Numeric (0 or 1). Recent significant head trauma (within 3 months). (1 = Yes).
}
  \item{current_anticoagulant_use}{
Numeric (0 or 1). Current use of anticoagulant medication (e.g., warfarin, DOACs). (1 = Yes).
}
  \item{platelet_count}{
Numeric. Platelet count in /mm^3. (< 100,000 is a contraindication).
}
  \item{inr}{
Numeric. International Normalized Ratio. (> 1.7 is a contraindication).
}
  \item{aptt}{
Numeric. Activated Partial Thromboplastin Time in seconds. (Elevated aPTT in heparin users is a contraindication).
}
  \item{pt}{
Numeric. Prothrombin Time in seconds. (> 15s is a contraindication).
}
  \item{glucose}{
Numeric. Blood glucose level in mg/dL. (< 50 mg/dL is a contraindication).
}
}
\value{
A list containing:
\item{Recommendation}{"tPA Contraindicated" or "tPA May be Indicated".}
\item{Contraindications_Present}{A list of specific contraindications identified.}
}
\references{
Powers WJ, et al. 2018 Guidelines for the Early Management of Patients With Acute Ischemic Stroke: A Guideline for Healthcare Professionals From the American Heart Association/American Stroke Association. Stroke. 2018.
}
\examples{

# Example 1: Contraindicated (Time window)
# 5 hours duration, otherwise normal
check_tpa_contraindications(5, 65, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 250000, 1.0, 30, 12, 100)

# Example 2: Contraindicated (History of ICH)
# 2 hours, Hx ICH
check_tpa_contraindications(2, 70, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 200000, 1.0, 30, 12, 90)

# Example 3: Indicated
# 2 hours, No contraindications
check_tpa_contraindications(2, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 200000, 1.0, 30, 12, 100)
}
