\name{crusade_bleeding_score}
\alias{crusade_bleeding_score}
\title{
CRUSADE Score for Post-MI Bleeding Risk
}
\description{
Calculates the CRUSADE Bleeding Score to stratify the risk of in-hospital major bleeding in patients with NSTEMI (Non-ST-Elevation Myocardial Infarction). The score helps guide the choice and dosing of antithrombotic therapies to balance ischemic benefit against bleeding risk.
}
\usage{
crusade_bleeding_score(hematocrit_percent, creatinine_clearance, heart_rate,
                       sex, chf_signs, prior_vascular_disease, diabetes,
                       systolic_bp)
}
\arguments{
  \item{hematocrit_percent}{
Numeric. Baseline hematocrit level (\%).
<31: +9 pts.
31-33.9: +7 pts.
34-36.9: +3 pts.
37-39.9: +2 pts.
>=40: 0 pts.
}
  \item{creatinine_clearance}{
Numeric. Creatinine clearance in mL/min (typically calculated via Cockcroft-Gault).
<=15: +39 pts.
>15-30: +35 pts.
>30-60: +28 pts.
>60-90: +17 pts.
>90-120: +7 pts.
>120: 0 pts.
}
  \item{heart_rate}{
Numeric. Heart rate at presentation (bpm).
<=70: 0 pts.
71-80: +1 pt.
81-90: +3 pts.
91-100: +6 pts.
101-110: +8 pts.
111-120: +10 pts.
>=121: +11 pts.
}
  \item{sex}{
String. "Male" (0 pts) or "Female" (+8 pts).
}
  \item{chf_signs}{
Numeric (0 or 1). Signs of Congestive Heart Failure at presentation. (1 = Yes, +7 pts).
}
  \item{prior_vascular_disease}{
Numeric (0 or 1). History of prior vascular disease (e.g., PAD, Stroke). (1 = Yes, +6 pts).
}
  \item{diabetes}{
Numeric (0 or 1). History of Diabetes Mellitus. (1 = Yes, +6 pts).
}
  \item{systolic_bp}{
Numeric. Systolic Blood Pressure at presentation (mmHg).
<=90: +10 pts.
91-100: +8 pts.
101-120: +5 pts.
121-180: +1 pt.
181-200: +3 pts.
>=201: +5 pts.
}
}
\value{
A list containing:
\item{CRUSADE_Score}{The calculated total score (Range 0-96).}
\item{Risk_Category}{Classification (Very Low, Low, Moderate, High, Very High).}
\item{In_Hospital_Major_Bleeding_Risk}{Estimated percentage probability of major bleeding.}
}
\references{
Subherwal S, Bach RG, Chen AY, et al. Baseline risk of major bleeding in non-ST-segment elevation myocardial infarction: the CRUSADE Bleeding Score. Circulation. 2009;119(14):1873-1882. doi:10.1161/CIRCULATIONAHA.108.828541
}
\examples{

# Example 1: High Risk
# Hct 28 (+9), CrCl 25 (+35), HR 115 (+10), Female (+8), SBP 100 (+8), No other factors
# Score = 70
crusade_bleeding_score(28, 25, 115, "female", 0, 0, 0, 100)

# Example 2: Low Risk
# Hct 42 (0), CrCl 100 (+7), HR 70 (0), Male (0), SBP 130 (+1), No other factors
# Score = 8
crusade_bleeding_score(42, 100, 70, "male", 0, 0, 0, 130)
}
