\name{csha_clinical_frailty_scale}
\alias{csha_clinical_frailty_scale}
\title{
CSHA Clinical Frailty Scale (CFS)
}
\description{
Retrieves the category and description for the Clinical Frailty Scale (CFS), developed by the Canadian Study of Health and Aging (CSHA). The scale assigns a score from 1 to 9 to summarize the overall level of fitness or frailty of an older adult after a comprehensive clinical evaluation.
}
\usage{
csha_clinical_frailty_scale(cfs_level)
}
\arguments{
  \item{cfs_level}{
Numeric (1-9). The selected frailty level based on clinical judgment.
1: Very Fit
2: Well
3: Managing Well
4: Vulnerable
5: Mildly Frail
6: Moderately Frail
7: Severely Frail
8: Very Severely Frail
9: Terminally Ill
}
}
\value{
A list containing:
\item{CFS_Level}{The input level.}
\item{Category}{The short title of the frailty stage.}
\item{Description}{The detailed clinical description defining the stage.}
}
\references{
Rockwood K, Song X, MacKnight C, et al. A global clinical measure of fitness and frailty in elderly people. CMAJ. 2005;173(5):489-495. doi:10.1503/cmaj.050051
}
\examples{

# Example 1: Managing Well
csha_clinical_frailty_scale(3)

# Example 2: Moderately Frail
csha_clinical_frailty_scale(6)
}
