\name{das28_esr_rheumatoid_arthritis}
\alias{das28_esr_rheumatoid_arthritis}
\title{
Disease Activity Score-28 for Rheumatoid Arthritis (DAS28-ESR)
}
\description{
Calculates the DAS28-ESR score, a standardized index of disease activity in Rheumatoid Arthritis. The score is calculated using the tender joint count (28 joints), swollen joint count (28 joints), Erythrocyte Sedimentation Rate (ESR), and the patient's global assessment of health. It stratifies patients into Remission, Low, Moderate, or High disease activity.
}
\usage{
das28_esr_rheumatoid_arthritis(tender_joint_count, swollen_joint_count,
                               esr_mm_hr, patient_global_health)
}
\arguments{
  \item{tender_joint_count}{
Numeric (0-28). Number of tender joints identified during examination.
}
  \item{swollen_joint_count}{
Numeric (0-28). Number of swollen joints identified during examination.
}
  \item{esr_mm_hr}{
Numeric. Erythrocyte Sedimentation Rate in mm/hr.
}
  \item{patient_global_health}{
Numeric (0-100). Patient's global assessment of health on a visual analog scale (0 = best/no activity, 100 = worst/highest activity).
}
}
\value{
A list containing:
\item{DAS28_ESR_Score}{The calculated disease activity score.}
\item{Disease_Activity}{Classification (Remission < 2.6, Low 2.6-3.2, Moderate 3.2-5.1, High > 5.1).}
}
\references{
Prevoo ML, van 't Hof MA, Kuper HH, et al. Modified disease activity scores that include twenty-eight-joint counts. Development and validation in a prospective longitudinal study of patients with rheumatoid arthritis. Arthritis Rheum. 1995;38(1):44-48.
}
\examples{

# Example 1: High Disease Activity
# 12 tender, 10 swollen, ESR 60, Global Health 70
das28_esr_rheumatoid_arthritis(12, 10, 60, 70)

# Example 2: Remission
# 0 tender, 0 swollen, ESR 10, Global Health 10
das28_esr_rheumatoid_arthritis(0, 0, 10, 10)
}
