\name{dsm5_bipolar_criteria}
\alias{dsm5_bipolar_criteria}
\title{
DSM-5 Criteria for Bipolar Disorder
}
\description{
Evaluates patient symptoms against the DSM-5 criteria for Bipolar I and Bipolar II Disorders. The function determines if a distinct period of abnormal mood qualifies as a Manic or Hypomanic episode based on symptom count, duration, and severity, and then applies diagnostic hierarchy (e.g., presence of Mania implies Bipolar I; Hypomania + Major Depression implies Bipolar II).
}
\usage{
dsm5_bipolar_criteria(symptom_count, irritable_mood_only, duration_days,
                      hospitalized, psychotic_features, marked_impairment,
                      history_mde, substance_medical_excluded)
}
\arguments{
  \item{symptom_count}{
Numeric. Number of Criterion B symptoms present (e.g., grandiosity, decreased sleep, pressured speech, flight of ideas, distractibility, increased activity, risk-taking).
}
  \item{irritable_mood_only}{
Numeric (0 or 1). Is the mood disturbance characterized ONLY by irritability (without elation/expansiveness)? (1 = Yes). If Yes, the symptom threshold increases from 3 to 4.
}
  \item{duration_days}{
Numeric. Duration of the mood disturbance in days.
}
  \item{hospitalized}{
Numeric (0 or 1). Did the episode require hospitalization? (1 = Yes).
}
  \item{psychotic_features}{
Numeric (0 or 1). Were psychotic features present? (1 = Yes).
}
  \item{marked_impairment}{
Numeric (0 or 1). Did the episode cause marked impairment in social or occupational functioning? (1 = Yes).
}
  \item{history_mde}{
Numeric (0 or 1). Is there a history of at least one Major Depressive Episode? (1 = Yes). Required for Bipolar II diagnosis.
}
  \item{substance_medical_excluded}{
Numeric (0 or 1). Have physiological effects of a substance or another medical condition been ruled out? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{The provisional diagnosis (Bipolar I, Bipolar II, or Criteria Not Met).}
\item{Current_Episode_Type}{Classification of the current/reported episode (Manic, Hypomanic, or None).}
}
\references{
American Psychiatric Association. Diagnostic and Statistical Manual of Mental Disorders. 5th ed. Arlington, VA: American Psychiatric Association; 2013.
}
\examples{

# Example 1: Bipolar I (Manic Episode)
# 3 symptoms, elated mood (irritable=0), 7 days duration, marked impairment
dsm5_bipolar_criteria(3, 0, 7, 0, 0, 1, 1, 1)

# Example 2: Bipolar II (Hypomanic + MDE)
# 4 symptoms, 4 days, no severe features, History of MDE
dsm5_bipolar_criteria(4, 0, 4, 0, 0, 0, 1, 1)

# Example 3: Criteria Not Met (Duration too short)
# 3 symptoms, 2 days, no hospitalization
dsm5_bipolar_criteria(3, 0, 2, 0, 0, 0, 1, 1)
}
