\name{duke_iscvid_2023}
\alias{duke_iscvid_2023}
\title{
2023 Duke-ISCVID Criteria for Infective Endocarditis
}
\description{
Calculates the classification for Infective Endocarditis (IE) based on the 2023 Duke-International Society for Cardiovascular Infectious Diseases (ISCVID) Criteria. These criteria update the Modified Duke Criteria (2000) with clarifications on microbiology, new imaging modalities (PET/CT), and expanded lists of predisposing conditions and vascular phenomena.

Classifications returned:
- Definite IE: Pathologic criteria OR 2 Major OR 1 Major + 3 Minor OR 5 Minor.
- Possible IE: 1 Major + 1 Minor OR 3 Minor.
- Rejected IE: Does not meet above criteria.
}
\usage{
duke_iscvid_2023(pathologic_criteria, major_microbiology, major_imaging,
                 predisposition, fever, vascular, immunologic, minor_microbiology)
}
\arguments{
  \item{pathologic_criteria}{
Numeric (0 or 1). Pathologic lesions (vegetations/intracardiac abscess) or microorganisms demonstrated by culture/histology/PCR in a cardiac vegetation, embolized vegetation, or intracardiac abscess.
}
  \item{major_microbiology}{
Numeric (0 or 1). Positive blood cultures for IE (typical microorganisms, persistent positives, single positive for C. burnetii, etc.) as defined by ISCVID 2023.
}
  \item{major_imaging}{
Numeric (0 or 1). Echocardiogram positive for IE (vegetation, abscess, perforation, etc.), Cardiac CT, or [18F]FDG-PET/CT showing abnormal metabolic activity.
}
  \item{predisposition}{
Numeric (0 or 1). Predisposing heart condition (prosthetic valve, prior IE, CHD, etc.) or Injection Drug Use (IDU).
}
  \item{fever}{
Numeric (0 or 1). Temperature > 38.0 degrees C.
}
  \item{vascular}{
Numeric (0 or 1). Vascular phenomena: arterial emboli, septic pulmonary infarcts, infectious (mycotic) aneurysm, intracranial hemorrhage, conjunctival hemorrhages, or Janeway's lesions.
}
  \item{immunologic}{
Numeric (0 or 1). Immunologic phenomena: Glomerulonephritis, Osler's nodes, Roth's spots, or Rheumatoid factor.
}
  \item{minor_microbiology}{
Numeric (0 or 1). Positive blood culture that does not meet a major criterion as noted above.
}
}
\value{
A list containing the final Classification (Definite, Possible, or Rejected), the Reasoning (rule applied), and a count of Major/Minor criteria met.
}
\references{
Fowler VG, Durack DT, Selton-Suty C, et al. The 2023 Duke-ISCVID Criteria for Infective Endocarditis: Updating the Modified Duke Criteria. Clin Infect Dis. 2023;77(4):518-526. doi:10.1093/cid/ciad271
}
\examples{

# Example 1: Definite IE (1 Major + 3 Minor)
# No Pathologic, Major Imaging, Fever, Vascular, Immunologic
duke_iscvid_2023(0, 0, 1, 0, 1, 1, 1, 0)

# Example 2: Possible IE (1 Major + 1 Minor)
# Major Micro, Predisposition only
duke_iscvid_2023(0, 1, 0, 1, 0, 0, 0, 0)

# Example 3: Definite IE via Pathologic Criteria
duke_iscvid_2023(1, 0, 0, 0, 0, 0, 0, 0)
}
