\name{eular_acr_pmr_calc}
\alias{eular_acr_pmr_calc}
\title{
2012 EULAR/ACR Classification Criteria for Polymyalgia Rheumatica
}
\description{
Calculates the classification score for Polymyalgia Rheumatica (PMR) based on the 2012 EULAR/ACR provisional criteria. The algorithm applies to patients >= 50 years old presenting with new bilateral shoulder pain and elevated CRP/ESR.

The function supports both the Clinical Criteria (Score >= 4 classifies as PMR) and the Clinical + Ultrasound Criteria (Score >= 5 classifies as PMR).
}
\usage{
eular_acr_pmr_calc(age, stiffness_gt_45, hip_pain_limited_rom,
                   neg_serology, no_peripheral_pain, use_ultrasound = FALSE,
                   us_abn_shoulder_and_hip = 0, us_abn_both_shoulders = 0)
}
\arguments{
  \item{age}{
Numeric or String. Patient age in years. Must be >= 50 to proceed.
}
  \item{stiffness_gt_45}{
Numeric or String (0 or 1). Morning stiffness duration > 45 minutes. 1 = Yes, 0 = No. (+2 points).
}
  \item{hip_pain_limited_rom}{
Numeric or String (0 or 1). Hip pain or limited range of motion. 1 = Yes, 0 = No. (+1 point).
}
  \item{neg_serology}{
Numeric or String (0 or 1). Negative RF and ACPA. 1 = Yes, 0 = No. (+2 points).
}
  \item{no_peripheral_pain}{
Numeric or String (0 or 1). Absence of other joint pain. 1 = Yes, 0 = No. (+1 point).
}
  \item{use_ultrasound}{
Logical. Set to TRUE to include ultrasound criteria in the scoring algorithm. Defaults to FALSE.
}
  \item{us_abn_shoulder_and_hip}{
Numeric or String (0 or 1). At least 1 shoulder with subdeltoid bursitis/biceps tenosynovitis/glenohumeral synovitis AND at least 1 hip with synovitis/trochanteric bursitis. (+1 point).
}
  \item{us_abn_both_shoulders}{
Numeric or String (0 or 1). Both shoulders with subdeltoid bursitis, biceps tenosynovitis, or glenohumeral synovitis. (+1 point).
}
}
\value{
A list containing the total score, the classification threshold used, and the final result ("Classified as PMR" or "Not Classified as PMR").
}
\references{
Dasgupta B, Cimmino MA, Maradit-Kremers H, et al. 2012 provisional classification criteria for polymyalgia rheumatica: a European League Against Rheumatism/American College of Rheumatology collaborative initiative. Ann Rheum Dis. 2012;71(4):484-492. doi:10.1136/annrheumdis-2011-200329
}
\examples{

# Clinical criteria only: Patient with stiffness and negative serology
eular_acr_pmr_calc(age = 65, stiffness_gt_45 = 1, hip_pain_limited_rom = 0,
                   neg_serology = 1, no_peripheral_pain = 0)

# Clinical + Ultrasound criteria
eular_acr_pmr_calc(age = 70, stiffness_gt_45 = 1, hip_pain_limited_rom = 1,
                   neg_serology = 0, no_peripheral_pain = 0,
                   use_ultrasound = TRUE, us_abn_both_shoulders = 1)
}
