\name{gillmore_attr_cm_staging}
\alias{gillmore_attr_cm_staging}
\title{
Gillmore Staging System for ATTR-CM
}
\description{
Calculates the Gillmore Stage (I, II, or III) for patients with Transthyretin Amyloid Cardiomyopathy (ATTR-CM). This prognostic staging system applies to both wild-type and hereditary subtypes. It uses NT-proBNP (cutoff 3000 pg/mL) and eGFR (cutoff 45 mL/min/1.73m^2) to stratify patients into three risk groups.
}
\usage{
gillmore_attr_cm_staging(nt_probnp_pg_ml, egfr_ml_min_1_73m2,
                         genotype = "wild-type")
}
\arguments{
  \item{nt_probnp_pg_ml}{
Numeric. N-terminal pro-B-type Natriuretic Peptide level in pg/mL.
}
  \item{egfr_ml_min_1_73m2}{
Numeric. Estimated Glomerular Filtration Rate in mL/min/1.73m^2.
}
  \item{genotype}{
String. "wild-type" (default) or "hereditary"/"variant". Note: The staging cutoffs are universal, but original derivation included both populations.
}
}
\value{
A list containing:
\item{Gillmore_Stage}{The calculated stage (1, 2, or 3).}
\item{Median_Overall_Survival}{Estimated median survival based on the NAC derivation cohort.}
}
\references{
Gillmore JD, Dzonlic H,any T, et al. Transthyretin Amyloid Cardiomyopathy: Clinical Features and Outcome in a Large Cohort. Circulation. 2017;136(22):2119-2131. doi:10.1161/CIRCULATIONAHA.117.030458
}
\examples{

# Example 1: Stage I (Low Risk)
# NT-proBNP 1000 (<3000), eGFR 60 (>=45)
gillmore_attr_cm_staging(1000, 60)

# Example 2: Stage III (High Risk)
# NT-proBNP 4000 (>3000), eGFR 30 (<45)
gillmore_attr_cm_staging(4000, 30)

# Example 3: Stage II (Intermediate)
# NT-proBNP 4000 (>3000), but eGFR 60 (>=45) -> One criteria met
gillmore_attr_cm_staging(4000, 60)
}
