\name{gupta_pneumonia_risk}
\alias{gupta_pneumonia_risk}
\title{
Gupta Postoperative Pneumonia Risk
}
\description{
Calculates the percentage risk of developing postoperative pneumonia based on the Gupta et al. (2013) model derived from the NSQIP database. This calculator is designed for adult patients undergoing non-cardiac and cardiac surgeries.
}
\usage{
gupta_pneumonia_risk(age, copd, functional_status, asa_class, sepsis_status,
                     smoker, procedure_type)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{copd}{
Numeric (0 or 1). History of COPD. (1 = Yes).
}
  \item{functional_status}{
String. Preoperative functional status. Options: "independent", "partially_dependent", "totally_dependent".
}
  \item{asa_class}{
Numeric. ASA Physical Status Classification (1-5).
}
  \item{sepsis_status}{
String. Preoperative sepsis category. Options: "none", "sirs" (Systemic Inflammatory Response Syndrome), "sepsis", "septic_shock".
}
  \item{smoker}{
Numeric (0 or 1). Current smoker (within 1 year). (1 = Yes).
}
  \item{procedure_type}{
String. Surgical procedure category. Valid options include:
"anorectal", "aortic", "bariatric", "brain", "breast", "cardiac", "ent", "foregut_hepatopancreatobiliary", "gallbladder_appendix_adrenal_spleen", "hernia_ventral_inguinal", "intestinal", "neck_thyroid_parathyroid", "obgyn", "orthopedic", "other_abdominal", "peripheral_vascular", "skin", "spine", "thoracic_non_cardiac", "urology", "vein".
}
}
\value{
A list containing:
\item{Pneumonia_Risk_Percent}{The estimated probability of postoperative pneumonia.}
}
\references{
Gupta H, Gupta PK, Schuller D, et al. Development and validation of a risk calculator for predicting postoperative pneumonia. Mayo Clin Proc. 2013;88(11):1241-1249. doi:10.1016/j.mayocp.2013.06.027
}
\examples{

# Example 1: High Risk (Aortic Surgery)
# 75yo, COPD, Totally Dependent, ASA 4, Sepsis, Smoker
gupta_pneumonia_risk(75, 1, "totally_dependent", 4, "sepsis", 1, "aortic")

# Example 2: Low Risk (Hernia Repair)
# 40yo, Independent, ASA 1, No Sepsis/Smoke
gupta_pneumonia_risk(40, 0, "independent", 1, "none", 0, "hernia_ventral_inguinal")
}
