\name{hark_screen}
\alias{hark_screen}
\title{
HARK Screen for Intimate Partner Violence
}
\description{
Calculates the HARK score, a brief 4-item screening tool designed to identify intimate partner violence (IPV) in clinical settings. The acronym stands for Humiliation, Afraid, Rape, and Kick. A score of 1 or greater indicates a positive screen.
}
\usage{
hark_screen(humiliation, afraid, rape, kick)
}
\arguments{
  \item{humiliation}{
Numeric (0 or 1). Within the last year, have you been humiliated or emotionally abused in other ways by your partner or your ex-partner? (1 = Yes).
}
  \item{afraid}{
Numeric (0 or 1). Within the last year, have you been afraid of your partner or ex-partner? (1 = Yes).
}
  \item{rape}{
Numeric (0 or 1). Within the last year, have you been raped or forced to have any kind of sexual activity by your partner or ex-partner? (1 = Yes).
}
  \item{kick}{
Numeric (0 or 1). Within the last year, have you been kicked, hit, slapped, or otherwise physically hurt by your partner or ex-partner? (1 = Yes).
}
}
\value{
A list containing:
\item{HARK_Score}{The calculated total score (Range 0-4).}
\item{Screen_Result}{"Positive Screen" (Score >= 1) or "Negative Screen".}
\item{Recommendation}{Clinical guidance based on the result.}
}
\references{
Sohal H, Eldridge S, Feder G. The sensitivity and specificity of four questions (HARK) to identify intimate partner violence: a diagnostic accuracy study in general practice. BMC Fam Pract. 2007;8:49. doi:10.1186/1471-2296-8-49
}
\examples{

# Example 1: Positive Screen (Humiliation only)
# Score = 1
hark_screen(1, 0, 0, 0)

# Example 2: Positive Screen (Physical and Sexual violence)
# Score = 2
hark_screen(0, 0, 1, 1)

# Example 3: Negative Screen
# Score = 0
hark_screen(0, 0, 0, 0)
}
