\name{maggic_risk_score}
\alias{maggic_risk_score}
\title{
MAGGIC Heart Failure Risk Calculator
}
\description{
Calculates the MAGGIC (Meta-Analysis Global Group in Chronic Heart Failure) Risk Score to predict 1-year and 3-year mortality in patients with heart failure (both reduced and preserved ejection fraction).
}
\usage{
maggic_risk_score(age, lvef, sbp, bmi, creatinine, nyha_class, sex, smoker,
                  diabetes, copd, heart_failure_duration_gt_18mo, beta_blocker_use,
                  acei_arb_use, creatinine_units = "mg/dL")
}
\arguments{
  \item{age}{Numeric. Patient age in years.}
  \item{lvef}{Numeric. Left Ventricular Ejection Fraction (\%).}
  \item{sbp}{Numeric. Systolic Blood Pressure (mmHg).}
  \item{bmi}{Numeric. Body Mass Index (kg/m^2).}
  \item{creatinine}{Numeric. Serum Creatinine level.}
  \item{nyha_class}{Numeric (1-4). NYHA Functional Class.}
  \item{sex}{String. "Male" or "Female".}
  \item{smoker}{Numeric (0 or 1). Current smoker? (1 = Yes).}
  \item{diabetes}{Numeric (0 or 1). History of Diabetes? (1 = Yes).}
  \item{copd}{Numeric (0 or 1). History of COPD? (1 = Yes).}
  \item{heart_failure_duration_gt_18mo}{Numeric (0 or 1). Diagnosed with Heart Failure > 18 months ago? (1 = Yes).}
  \item{beta_blocker_use}{Numeric (0 or 1). Currently taking a Beta-blocker? (1 = Yes).}
  \item{acei_arb_use}{Numeric (0 or 1). Currently taking an ACE inhibitor or ARB? (1 = Yes).}
  \item{creatinine_units}{String. Units for creatinine. "mg/dL" (default) or "micromol/L" (or "umol/L").}
}
\value{
A list containing:
\item{MAGGIC_Risk_Score}{The calculated total integer score.}
\item{One_Year_Mortality_Risk}{Estimated probability of death at 1 year.}
\item{Three_Year_Mortality_Risk}{Estimated probability of death at 3 years.}
}
\references{
Pocock SJ, Ariti CA, McMurray JJ, et al. Predicting survival in heart failure: a risk score based on 39 372 patients from 30 studies. Eur Heart J. 2013;34(19):1404-1413. doi:10.1093/eurheartj/ehs337
}
\examples{

# Example 1: High Risk
# 75yo, EF 25, SBP 105, BMI 22, Cr 1.8, NYHA III, Male, COPD, No meds
maggic_risk_score(75, 25, 105, 22, 1.8, 3, "male", 0, 0, 1, 1, 0, 0)

# Example 2: Low Risk
# 50yo, EF 45, SBP 130, BMI 30, Cr 1.0, NYHA I, Female, No comorbidities, On meds
maggic_risk_score(50, 45, 130, 30, 1.0, 1, "female", 0, 0, 0, 0, 1, 1)
}
