\name{major_depression_index}
\alias{major_depression_index}
\title{
Major Depression Index (MDI)
}
\description{
Calculates the Major Depression Index (MDI) score, a self-rating scale used to measure the severity of depressive symptoms. It evaluates 10 items (with sub-items for psychomotor and appetite changes) on a 0-5 scale based on frequency over the last 2 weeks. The scoring logic takes the maximum value for items 8 (restlessness vs. slowed down) and 10 (reduced vs. increased appetite).
}
\usage{
major_depression_index(low_spirits, loss_of_interest, lacking_energy,
                       self_confidence, guilt, suicidal_ideation, concentration,
                       restlessness, slowed_down, sleep_trouble, reduced_appetite,
                       increased_appetite)
}
\arguments{
  \item{low_spirits}{Numeric (0-5). Frequency of feeling low in spirits or sad.}
  \item{loss_of_interest}{Numeric (0-5). Frequency of losing interest in daily activities.}
  \item{lacking_energy}{Numeric (0-5). Frequency of lacking energy/strength.}
  \item{self_confidence}{Numeric (0-5). Frequency of feeling less self-confident.}
  \item{guilt}{Numeric (0-5). Frequency of having a bad conscience or feelings of guilt.}
  \item{suicidal_ideation}{Numeric (0-5). Frequency of feeling that life isn't worth living.}
  \item{concentration}{Numeric (0-5). Frequency of trouble concentrating.}
  \item{restlessness}{Numeric (0-5). Frequency of feeling very restless (8a).}
  \item{slowed_down}{Numeric (0-5). Frequency of feeling subdued or slowed down (8b).}
  \item{sleep_trouble}{Numeric (0-5). Frequency of trouble sleeping at night.}
  \item{reduced_appetite}{Numeric (0-5). Frequency of reduced appetite (10a).}
  \item{increased_appetite}{Numeric (0-5). Frequency of increased appetite (10b).}
}
\details{
\strong{Scoring Key (Frequency over last 2 weeks):}
0 = At no time
1 = Some of the time
2 = Slightly less than half the time
3 = Slightly more than half the time
4 = Most of the time
5 = All the time
}
\value{
A list containing:
\item{MDI_Score}{The calculated total score (Range 0-50).}
\item{Severity_Category}{Interpretation (None <20, Mild 20-24, Moderate 25-29, Severe >=30).}
}
\references{
Bech P, Rasmussen NA, Olsen LR, Noerholm V, Abildgaard W. The sensitivity and specificity of the Major Depression Inventory, using the Present State Examination as the index of validity. J Affect Disord. 2001;66(2-3):159-164. doi:10.1016/s0165-0327(00)00309-8
}
\examples{

# Example 1: Severe Depression
# All items scored 4 or 5
major_depression_index(5, 5, 4, 4, 5, 2, 4, 5, 0, 4, 0, 5)

# Example 2: Mild Depression
# Scores around 2 or 3
major_depression_index(2, 3, 2, 2, 1, 0, 2, 2, 0, 3, 3, 0)
}
