\name{nafld_activity_score}
\alias{nafld_activity_score}
\title{
NAFLD Activity Score (NAS)
}
\description{
Calculates the NAFLD Activity Score (NAS) to assess the severity of Non-Alcoholic Fatty Liver Disease based on liver biopsy findings. The score sums grades for steatosis, lobular inflammation, and hepatocyte ballooning to help distinguish between Non-Alcoholic Steatohepatitis (NASH) and simple steatosis.
}
\usage{
nafld_activity_score(steatosis_grade, lobular_inflammation, hepatocyte_ballooning)
}
\arguments{
  \item{steatosis_grade}{
Numeric (0-3). Percentage of hepatocytes containing fat.
0: <5\%.
1: 5-33\%.
2: >33-66\%.
3: >66\%.
}
  \item{lobular_inflammation}{
Numeric (0-3). Number of inflammatory foci per 200x field.
0: No foci.
1: < 2 foci.
2: 2-4 foci.
3: > 4 foci.
}
  \item{hepatocyte_ballooning}{
Numeric (0-2). Amount of ballooning degeneration.
0: None.
1: Few balloon cells.
2: Many cells/prominent ballooning.
}
}
\value{
A list containing:
\item{NAS_Score}{The calculated total score (Range 0-8).}
\item{Interpretation}{Clinical likelihood of NASH.}
}
\references{
Kleiner DE, Brunt EM, Van Natta M, et al. Design and validation of a histological scoring system for nonalcoholic fatty liver disease. Hepatology. 2005;41(6):1313-1321. doi:10.1002/hep.20701
}
\examples{

# Example 1: NASH Likely
# Steatosis >66% (3), Inflammation >4 (3), Ballooning Many (2)
# Score = 8
nafld_activity_score(3, 3, 2)

# Example 2: Borderline
# Steatosis 5-33% (1), Inflammation <2 (1), Ballooning Few (1)
# Score = 3
nafld_activity_score(1, 1, 1)
}
