\name{nutric_score}
\alias{nutric_score}
\title{
Nutrition Risk in the Critically Ill (NUTRIC) Score
}
\description{
Calculates the **NUTRIC Score** to assess the risk of adverse outcomes from under-nutrition in critically ill adult patients. The score integrates patient characteristics (age, BMI), baseline health status (comorbidities, SOFA score), and anticipated length of stay. The maximum score is 5 points for the standard NUTRIC score.
}
\usage{
nutric_score(age, bmi, sofa_score, comorbidities_count, days_on_icu_ge_2,
             il6_level_pg_ml = NA)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (50-74 years adds 1 point, \eqn{\ge}75 years adds 1 point).
}
  \item{bmi}{
Numeric. Body Mass Index in kg/m^2. (BMI < 20 or \eqn{\ge} 35 adds 1 point).
}
  \item{sofa_score}{
Numeric. Sequential Organ Failure Assessment (SOFA) score on admission. (SOFA 5-9 adds 1 point, SOFA \eqn{\ge} 10 adds 1 point).
}
  \item{comorbidities_count}{
Numeric. Count of comorbidities (e.g., Cancer, CKD, Liver disease, CHF). (\eqn{\ge} 2 adds 1 point).
}
  \item{days_on_icu_ge_2}{
Numeric (0 or 1). Anticipated length of stay in the ICU of 2 days or more. (1 = Yes, +1 point).
}
  \item{il6_level_pg_ml}{
Numeric (Optional). Interleukin-6 (IL-6) level in pg/mL. Used in the modified NUTRIC (mNUTRIC) score. (\eqn{\ge} 1000 pg/mL adds 1 point if applicable to the highest category).
}
}
\value{
A list containing:
\item{NUTRIC_Score}{The calculated risk score (Range 0-5).}
\item{Risk_Classification}{Classification (Low Risk \eqn{\le} 4, High Risk \eqn{\ge} 5).}
\item{Nutrition_Recommendation}{Guidance on the intensity of nutrition support.}
}
\references{
*Original Derivation (NUTRIC):* Heyland DK, Dhaliwal R, Jiang X, et al. Identifying critically ill patients who benefit most from nutritional support: a systematic review and meta-analysis. Crit Care. 2011;15(4):R172. doi:10.1186/cc10362

*IL-6 Inclusion (mNUTRIC):* Rahman A, et al. Modified NUTRIC Score: Validation and Utility in Critical Care. J Am Coll Nutr. 2015.
}
\examples{

# Example 1: Low Risk
# 40yo (0), BMI 25 (0), SOFA 2 (0), 1 comorbidity (0), <2 ICU days (0)
nutric_score(40, 25, 2, 1, 0)

# Example 2: High Risk
# 70yo (+1), BMI 35 (+1), SOFA 12 (+1), 2 comorbidities (+1), >=2 ICU days (+1)
# Score = 5
nutric_score(70, 35, 12, 2, 1)
}
