\name{pediatric_nih_stroke_scale}
\alias{pediatric_nih_stroke_scale}
\title{
Pediatric NIH Stroke Scale (PedNIHSS)
}
\description{
Calculates the Pediatric NIH Stroke Scale (PedNIHSS) score. This is a validated adaptation of the standard NIHSS for use in children, using age-appropriate stimuli and instructions to assess neurological deficits in acute stroke. The scoring values (0 to 4) for each domain remain consistent with the adult scale.
}
\usage{
pediatric_nih_stroke_scale(loc_responsiveness, loc_questions, loc_commands, gaze,
                           visual_fields, facial_palsy, motor_arm_left,
                           motor_arm_right, motor_leg_left, motor_leg_right,
                           limb_ataxia, sensory, best_language, dysarthria,
                           extinction_inattention)
}
\arguments{
  \item{loc_responsiveness}{Numeric (0-3). 1a: Level of Consciousness (0=Alert, 3=Coma).}
  \item{loc_questions}{Numeric (0-2). 1b: LOC Questions (Age appropriate, e.g., month/age). (0=Both correct, 2=Neither correct).}
  \item{loc_commands}{Numeric (0-2). 1c: LOC Commands (Open/close eyes, grip hand). (0=Both correct, 2=Neither correct).}
  \item{gaze}{Numeric (0-2). 2: Best Gaze. (0=Normal, 2=Forced deviation).}
  \item{visual_fields}{Numeric (0-3). 3: Visual Fields. (0=No visual loss, 3=Bilateral hemianopia).}
  \item{facial_palsy}{Numeric (0-3). 4: Facial Palsy. (0=Normal, 3=Complete paralysis).}
  \item{motor_arm_left}{Numeric (0-4). 5a: Motor Arm Left. (0=No drift, 4=No movement).}
  \item{motor_arm_right}{Numeric (0-4). 5b: Motor Arm Right.}
  \item{motor_leg_left}{Numeric (0-4). 6a: Motor Leg Left. (0=No drift, 4=No movement).}
  \item{motor_leg_right}{Numeric (0-4). 6b: Motor Leg Right.}
  \item{limb_ataxia}{Numeric (0-2). 7: Limb Ataxia. (0=Absent, 2=Present in two limbs).}
  \item{sensory}{Numeric (0-2). 8: Sensory. (0=Normal, 2=Severe loss).}
  \item{best_language}{Numeric (0-3). 9: Best Language. (0=No aphasia, 3=Mute/Global aphasia).}
  \item{dysarthria}{Numeric (0-2). 10: Dysarthria. (0=Normal, 2=Severe).}
  \item{extinction_inattention}{Numeric (0-2). 11: Extinction and Inattention (Neglect). (0=No abnormality, 2=Profound hemi-inattention).}
}
\value{
A list containing:
\item{PedNIHSS_Score}{The calculated total score (Range 0-42).}
\item{Severity_Level}{Interpretation of stroke severity (No Symptoms, Minor, Moderate, Moderate-Severe, Severe).}
}
\references{
Beslow LA, Jordan LC. Pediatric Stroke: The Importance of Time and Team. Stroke. 2016.
Williams LS, Yilmaz EY, Lopez-Yunez AM. Retrospective assessment of initial stroke severity with the NIH Stroke Scale. Stroke. 2000;31(4):858-862.
}
\examples{

# Example 1: Moderate Stroke
# Drowsy(1), Partial Gaze(1), Facial Droop(2), Arm Drift(1), Mild Aphasia(1)
pediatric_nih_stroke_scale(1, 0, 0, 1, 0, 2, 1, 0, 0, 0, 0, 0, 1, 0, 0)

# Example 2: Severe Stroke
# Stuporous(2), Forced Gaze(2), Hemianopia(2), R-sided Paralysis(4,4), Global Aphasia(3), Neglect(2)
pediatric_nih_stroke_scale(2, 2, 0, 2, 2, 2, 0, 4, 0, 4, 0, 0, 3, 2, 2)
}
