\name{phases_aneurysm_score}
\alias{phases_aneurysm_score}
\title{
PHASES Score for Unruptured Intracranial Aneurysms
}
\description{
Calculates the PHASES score to predict the 5-year risk of aneurysm rupture in patients with unruptured intracranial aneurysms. The score is based on Population, Hypertension, Age, Size of aneurysm, Earlier SAH, and Site of aneurysm.
}
\usage{
phases_aneurysm_score(population, hypertension, age, aneurysm_size_mm,
                      history_sah, aneurysm_site)
}
\arguments{
  \item{population}{
String. Ethnicity/Population of the patient.
"other": North American, European (not Finnish) (0 points).
"japanese": Japanese (3 points).
"finnish": Finnish (5 points).
}
  \item{hypertension}{
Numeric (0 or 1). History of hypertension. (1 = Yes).
}
  \item{age}{
Numeric. Patient age in years. (>= 70 years adds 1 point).
}
  \item{aneurysm_size_mm}{
Numeric. Maximum diameter of the aneurysm in millimeters.
< 7.0 mm: 0 points.
7.0 - 9.9 mm: 3 points.
10.0 - 19.9 mm: 6 points.
>= 20.0 mm: 10 points.
}
  \item{history_sah}{
Numeric (0 or 1). History of Subarachnoid Hemorrhage (SAH) from another aneurysm. (1 = Yes).
}
  \item{aneurysm_site}{
String. Location of the aneurysm.
"ica": Internal Carotid Artery (0 points).
"mca": Middle Cerebral Artery (2 points).
"posterior_aca_pcom": Posterior circulation, Anterior Cerebral Artery, or Posterior Communicating Artery (4 points).
}
}
\value{
A list containing:
\item{PHASES_Score}{The calculated total score (Range 0-22).}
\item{Risk_5_Year_Rupture}{The estimated 5-year absolute risk of aneurysm rupture percentage.}
}
\references{
Greving JP, Wermer MJ, Brown RD Jr, et al. Development of the PHASES score for prediction of risk of rupture of intracranial aneurysms: a pooled analysis of six prospective cohort studies. Lancet Neurol. 2014;13(1):59-66. doi:10.1016/S1474-4422(13)70263-1
}
\examples{

# Example 1: Low Risk
# US patient, No HTN, Age 50, 4mm ICA aneurysm, No SAH history
# Score = 0 + 0 + 0 + 0 + 0 + 0 = 0
phases_aneurysm_score("other", 0, 50, 4, 0, "ica")

# Example 2: High Risk
# Finnish, HTN, Age 72, 8mm MCA aneurysm, History of SAH
# Score = 5 + 1 + 1 + 3 + 1 + 2 = 13
phases_aneurysm_score("finnish", 1, 72, 8, 1, "mca")
}
