\name{piro_cap_score}
\alias{piro_cap_score}
\title{
PIRO Score for Community-Acquired Pneumonia (CAP)
}
\description{
Calculates the PIRO score (Predisposition, Insult, Response, Organ dysfunction) to stratify the severity and mortality risk in patients admitted to the ICU with Community-Acquired Pneumonia.
}
\usage{
piro_cap_score(age, copd, immunocompromised, multilobar_opacities, bacteremia,
               shock, severe_hypoxemia, acute_renal_failure)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (> 70 years adds 1 point).
}
  \item{copd}{
Numeric (0 or 1). History of Chronic Obstructive Pulmonary Disease. (1 = Yes, +1 point).
}
  \item{immunocompromised}{
Numeric (0 or 1). Immunocompromised state (e.g., corticosteroids, HIV, chemotherapy, transplant). (1 = Yes, +1 point).
}
  \item{multilobar_opacities}{
Numeric (0 or 1). Presence of multilobar opacities on chest radiograph. (1 = Yes, +1 point).
}
  \item{bacteremia}{
Numeric (0 or 1). Presence of bacteremia (positive blood cultures). (1 = Yes, +1 point).
}
  \item{shock}{
Numeric (0 or 1). Systolic BP < 90 mmHg or requirement for vasopressors. (1 = Yes, +1 point).
}
  \item{severe_hypoxemia}{
Numeric (0 or 1). PaO2/FiO2 ratio < 150 mmHg. (1 = Yes, +1 point).
}
  \item{acute_renal_failure}{
Numeric (0 or 1). Serum Creatinine > 1.2 mg/dL (> 106 µmol/L) or BUN > 20 mg/dL (> 7.14 mmol/L). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{PIRO_Score}{The calculated score (Range 0-8).}
\item{Risk_Category}{Risk stratification (Low, Mild/Intermediate, High, Very High).}
\item{Mortality_Risk_28_Day}{Estimated 28-day mortality probability.}
}
\references{
Rello J, Rodriguez A, Lisboa T, et al. PIRO score for community-acquired pneumonia: a new prediction rule for assessment of severity in intensive care unit patients with community-acquired pneumonia. Crit Care Med. 2009;37(2):456-462. doi:10.1097/CCM.0b013e3181958ca0
}
\examples{

# Example 1: Low Risk
# Age 60, No comorbidities, Multilobar (1), No shock, Normal labs
# Score = 1
piro_cap_score(60, 0, 0, 1, 0, 0, 0, 0)

# Example 2: High Risk
# Age 75 (1), COPD (1), Shock (1), Renal Failure (1)
# Score = 4
piro_cap_score(75, 1, 0, 0, 0, 1, 0, 1)
}
