\name{psa_doubling_time}
\alias{psa_doubling_time}
\title{
PSA Doubling Time (PSADT) Calculator
}
\description{
Calculates the PSA Doubling Time, a kinetic measure of prostate cancer growth, using linear regression of the natural logarithm of PSA over time. This metric is commonly used to assess prognosis and guide treatment in patients with biochemical recurrence after definitive therapy.
}
\usage{
psa_doubling_time(psa_date1, psa_value1, psa_date2, psa_value2,
                  psa_date3 = NULL, psa_value3 = NULL)
}
\arguments{
  \item{psa_date1}{
Date string (YYYY-MM-DD). Date of the first PSA measurement.
}
  \item{psa_value1}{
Numeric. First PSA value in ng/mL.
}
  \item{psa_date2}{
Date string (YYYY-MM-DD). Date of the second PSA measurement.
}
  \item{psa_value2}{
Numeric. Second PSA value in ng/mL.
}
  \item{psa_date3}{
Date string (YYYY-MM-DD) (Optional). Date of the third PSA measurement.
}
  \item{psa_value3}{
Numeric (Optional). Third PSA value in ng/mL.
}
}
\details{
The calculation performs a linear regression of \eqn{\ln(PSA)} versus time (in months). The doubling time is calculated as \eqn{\frac{\ln(2)}{slope}}. At least two data points are required, but three provide a more robust estimate.
}
\value{
A list containing:
\item{PSA_Doubling_Time_Months}{The estimated time in months for the PSA level to double.}
}
\references{
Pound CR, Partin AW, Eisenberger MA, Chan DW, Pearson JD, Walsh PC. Natural history of progression after PSA elevation following radical prostatectomy. JAMA. 1999;281(17):1591-1597. doi:10.1001/jama.281.17.1591
}
\examples{

# Example 1: Two points
# Jan 1: PSA 4.0, July 1: PSA 8.0 (6 months later)
# Should double in approx 6 months
psa_doubling_time("2023-01-01", 4.0, "2023-07-01", 8.0)

# Example 2: Three points
# Jan: 2.0, Apr: 3.0, Jul: 4.5
psa_doubling_time("2023-01-01", 2.0, "2023-04-01", 3.0, "2023-07-01", 4.5)
}
