\name{race_stroke_scale}
\alias{race_stroke_scale}
\title{
Rapid Arterial Occlusion Evaluation (RACE) Scale for Stroke
}
\description{
Calculates the RACE Scale score to identify patients with acute stroke who are likely to have a Large Vessel Occlusion (LVO). This prehospital tool assesses 5 distinct neurological domains to help triage patients to the appropriate stroke center for endovascular treatment.
}
\usage{
race_stroke_scale(facial_palsy, arm_motor, leg_motor, head_gaze_deviation,
                  aphasia_or_agnosia)
}
\arguments{
  \item{facial_palsy}{
Numeric (0-2).
0: Absent.
1: Mild (droop).
2: Moderate to Severe (paralysis).
}
  \item{arm_motor}{
Numeric (0-2). Motor function of the affected arm.
0: Normal to Mild (holds > 10s).
1: Moderate (holds < 10s).
2: Severe (does not raise or creates no effort).
}
  \item{leg_motor}{
Numeric (0-2). Motor function of the affected leg.
0: Normal to Mild (holds > 5s).
1: Moderate (holds < 5s).
2: Severe (does not raise or creates no effort).
}
  \item{head_gaze_deviation}{
Numeric (0-1). Head and gaze deviation.
0: Absent.
1: Present (eyes or head deviated to one side).
}
  \item{aphasia_or_agnosia}{
Numeric (0-2). Assessment of cortical signs based on the side of hemiparesis.
If Right Hemiparesis (Left Hemisphere), assess Aphasia (Naming/Orders).
If Left Hemiparesis (Right Hemisphere), assess Agnosia (Arm/Anosognosia).
0: Normal.
1: Moderate.
2: Severe.
}
}
\value{
A list containing:
\item{RACE_Score}{The calculated total score (Range 0-9).}
\item{Interpretation}{Likelihood of LVO (Score >= 5 indicates high probability).}
\item{Performance_at_Cutoff_5}{Sensitivity and specificity metrics for LVO detection at the threshold of 5.}
}
\references{
Pérez de la Ossa N, Carrera D, Gorchs M, et al. Design and validation of a prehospital stroke scale to predict large arterial occlusion: the rapid arterial occlusion evaluation scale. Stroke. 2014;45(1):87-91. doi:10.1161/STROKEAHA.113.003071
}
\examples{

# Example 1: High Probability of LVO
# Moderate Face (2), Severe Arm (2), Severe Leg (2), Gaze (1), Severe Aphasia (2)
# Score = 9
race_stroke_scale(2, 2, 2, 1, 2)

# Example 2: Lower Probability
# Mild Face (1), Moderate Arm (1), Normal Leg (0), No Gaze (0), No Agnosia (0)
# Score = 2
race_stroke_scale(1, 1, 0, 0, 0)
}
