\name{rebound_hyperbilirubinemia_score}
\alias{rebound_hyperbilirubinemia_score}
\title{
Rebound Hyperbilirubinemia Risk Score
}
\description{
Calculates the risk of rebound hyperbilirubinemia (return of total serum bilirubin to phototherapy threshold within 72 hours) after discontinuation of inpatient phototherapy in neonates >= 35 weeks gestation. The score uses gestational age, age at phototherapy initiation, and the difference between the AAP phototherapy threshold and the TSB level at termination.
}
\usage{
rebound_hyperbilirubinemia_score(gestational_age_weeks, age_initiation_hours,
                                 tsb_termination_mg_dl, aap_threshold_mg_dl)
}
\arguments{
  \item{gestational_age_weeks}{
Numeric. Gestational age in weeks (Must be >= 35).
}
  \item{age_initiation_hours}{
Numeric. Postnatal age in hours at the time phototherapy was initiated.
}
  \item{tsb_termination_mg_dl}{
Numeric. Total Serum Bilirubin level (mg/dL) at the time of phototherapy discontinuation.
}
  \item{aap_threshold_mg_dl}{
Numeric. The AAP phototherapy treatment threshold (mg/dL) for the infant at the time of discontinuation.
}
}
\value{
A list containing:
\item{Rebound_Score}{The calculated risk score.}
\item{Rebound_Risk_Probability}{Estimated probability of rebound hyperbilirubinemia.}
}
\references{
Chang PW, Kuzniewicz MW, McCulloch CE, Newman TB. A Clinical Prediction Rule for Rebound Hyperbilirubinemia Following Inpatient Phototherapy. Pediatrics. 2017;139(3):e20162896. doi:10.1542/peds.2016-2896
}
\examples{

# Example 1: Low Risk
# 39 weeks, Started at 48 hours, TSB 12, Threshold 16 (Diff 4)
# Score = 0 - 7(2) - 4(4) + 50 = -14 - 16 + 50 = 20
rebound_hyperbilirubinemia_score(39, 48, 12, 16)

# Example 2: High Risk
# 36 weeks (<38), Started at 24 hours, TSB 13, Threshold 14 (Diff 1)
# Score = 15 - 7(1) - 4(1) + 50 = 15 - 7 - 4 + 50 = 54
rebound_hyperbilirubinemia_score(36, 24, 13, 14)
}
