\name{rip_patella_score}
\alias{rip_patella_score}
\title{
Recurrent Instability of the Patella (RIP) Score
}
\description{
Calculates the RIP Score to predict the risk of recurrent patellar dislocation. The score utilizes four clinical and radiographic factors: age, skeletal maturity (open physes), trochlear dysplasia, and history of contralateral dislocation.
}
\usage{
rip_patella_score(age, skeletal_immature, trochlear_dysplasia,
                  contralateral_dislocation)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (< 25 years adds 2 points).
}
  \item{skeletal_immature}{
Numeric (0 or 1). Are physes open (skeletally immature)? (1 = Yes, +1 point).
}
  \item{trochlear_dysplasia}{
Numeric (0 or 1). Presence of trochlear dysplasia on lateral radiograph. (1 = Yes, +1 point).
}
  \item{contralateral_dislocation}{
Numeric (0 or 1). History of contralateral patellar dislocation. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{RIP_Score}{The calculated total score (Range 0-5).}
\item{Risk_Category}{Classification (Low 0-1, Intermediate 2-3, High 4-5).}
\item{Recurrence_Risk}{Estimated percentage risk of recurrence.}
}
\references{
Cheung JP, Fung B, Ip WY, Chow SP. Review on recurrent dislocation of the patella. Orthopedics. 2008;31(1):76-80.
Hevesi M, Heckmann N, Brown GA, et al. The Recurrent Instability of the Patella (RIP) Score: A Statistically Based Predictive Tool for Recurrent Patellar Instability. Am J Sports Med. 2019;47(4):922-928. doi:10.1177/0363546518825255
}
\examples{

# Example 1: High Risk
# 16yo (+2), Open Physes (+1), Dysplasia (+1), No contralateral history
# Score = 4
rip_patella_score(16, 1, 1, 0)

# Example 2: Low Risk
# 30yo (0), Closed Physes (0), Dysplasia (1), No contralateral history
# Score = 1
rip_patella_score(30, 0, 1, 0)
}
