\name{rome_iv_caps_criteria}
\alias{rome_iv_caps_criteria}
\title{
Rome IV Diagnostic Criteria for Centrally Mediated Abdominal Pain Syndrome (CAPS)
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Centrally Mediated Abdominal Pain Syndrome (CAPS)** (formerly Functional Abdominal Pain Syndrome, FAPS). CAPS is a functional disorder characterized by chronic, often continuous abdominal pain that has lost its association with gastrointestinal function and significantly impairs daily activities.
}
\usage{
rome_iv_caps_criteria(chronic_abdominal_pain, loss_of_social_functioning,
                      pain_not_explained_by_other_fgid, pain_not_explained_by_organic,
                      symptom_onset_ge_6_months, symptoms_active_last_3_months)
}
\arguments{
  \item{chronic_abdominal_pain}{
Numeric (0 or 1). Presence of **chronic or continuous abdominal pain**. (1 = Yes).
}
  \item{loss_of_social_functioning}{
Numeric (0 or 1). Pain associated with significant **loss of daily, social, or work functioning** or recurrent medical visits. (1 = Yes).
}
  \item{pain_not_explained_by_other_fgid}{
Numeric (0 or 1). **Not** meeting criteria for another functional gastrointestinal disorder (FGID) that could explain the pain (e.g., IBS, functional dyspepsia). (1 = Yes).
}
  \item{pain_not_explained_by_organic}{
Numeric (0 or 1). **Not** better explained by an organic gastrointestinal disease. (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least **6 months ago**? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last **3 months**? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Centrally Mediated Abdominal Pain Syndrome (CAPS)" or "Criteria Not Met".}
}
\references{
Drossman DA, Hasler WL. The Rome IV Criteria: Innovations and Impact on Clinical Practice. J Clin Gastroenterol. 2016;50(Suppl 1):S1-S7. doi:10.1097/MCG.0000000000000624
}
\examples{

# Example 1: Diagnosis Met
# Chronic pain (1), Social impact (1), No other FGID/Organic cause, Chronic duration met
rome_iv_caps_criteria(1, 1, 1, 1, 1, 1)

# Example 2: Not Met (Pain can be explained by IBS)
# Chronic pain (1), Social impact (1), Meets IBS criteria (0 for exclusion)
rome_iv_caps_criteria(1, 1, 0, 1, 1, 1)
}
