\name{rome_iv_child_functional_dyspepsia}
\alias{rome_iv_child_functional_dyspepsia}
\title{
Rome IV Diagnostic Criteria for Child Functional Dyspepsia
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Functional Dyspepsia** in children and adolescents. Functional dyspepsia is sub-classified into Postprandial Distress Syndrome (PDS) and Epigastric Pain Syndrome (EPS). Diagnosis requires symptoms to be present for at least 3 months, with onset at least 6 months prior, and the absence of organic disease that explains the symptoms.
}
\usage{
rome_iv_child_functional_dyspepsia(postprandial_fullness, early_satiation,
                                    epigastric_pain, epigastric_burning,
                                    organic_disease_excluded, symptom_onset_ge_6_months,
                                    symptoms_active_last_3_months)
}
\arguments{
  \item{postprandial_fullness}{
Numeric (0 or 1). Presence of bothersome **postprandial fullness** (at least 4 days a week). (1 = Yes). This is a criterion for PDS.
}
  \item{early_satiation}{
Numeric (0 or 1). Presence of bothersome **early satiation** (at least 4 days a week). (1 = Yes). This is a criterion for PDS.
}
  \item{epigastric_pain}{
Numeric (0 or 1). Presence of bothersome **epigastric pain** (at least 1 day a week). (1 = Yes). This is a criterion for EPS.
}
  \item{epigastric_burning}{
Numeric (0 or 1). Presence of bothersome **epigastric burning** (at least 1 day a week). (1 = Yes). This is a criterion for EPS.
}
  \item{organic_disease_excluded}{
Numeric (0 or 1). Exclusion of organic disease (e.g., peptic ulcer, esophagitis) by upper endoscopy. (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least **6 months ago**? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last **3 months**? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{The resulting classification (PDS, EPS, Overlap, or Not Met).}
}
\references{
Hyams JS, Di Lorenzo C, Saps M, et al. Functional Disorders: Children and Adolescents. Gastroenterology. 2016;150:1456-1468. doi:10.1053/j.gastro.2016.02.015
}
\examples{

# Example 1: Postprandial Distress Syndrome (PDS)
# Fullness (1), Early Satiation (0), No pain/burning, Organic excluded, Chronic duration met
rome_iv_child_functional_dyspepsia(1, 0, 0, 0, 1, 1, 1)

# Example 2: Overlap Dyspepsia
# Fullness (1), Pain (1), Organic excluded, Chronic duration met
rome_iv_child_functional_dyspepsia(1, 0, 1, 0, 1, 1, 1)
}
