\name{rome_iv_infant_functional_constipation}
\alias{rome_iv_infant_functional_constipation}
\title{
Rome IV Diagnostic Criteria for Infant Functional Constipation
}
\description{
Evaluates the Rome IV criteria for diagnosing **Functional Constipation** in infants (from birth to 4 years of age). Diagnosis requires at least **two** of the five listed symptoms for at least 1 month, and the symptoms cannot be explained by another medical condition.
}
\usage{
rome_iv_infant_functional_constipation(stool_frequency_lt_3_week, hard_lumpy_stool,
                                       straining, large_diameter_stool,
                                       rectal_fecal_mass, no_other_cause)
}
\arguments{
  \item{stool_frequency_lt_3_week}{
Numeric (0 or 1). Less than **three bowel movements** per week. (1 = Yes).
}
  \item{hard_lumpy_stool}{
Numeric (0 or 1). History of passing **hard or lumpy stools** (Bristol Stool Form Scale 1-2). (1 = Yes).
}
  \item{straining}{
Numeric (0 or 1). History of excessive **straining** or holding back stools. (1 = Yes).
}
  \item{large_diameter_stool}{
Numeric (0 or 1). History of passing **large diameter stools**. (1 = Yes).
}
  \item{rectal_fecal_mass}{
Numeric (0 or 1). Presence of a **large fecal mass** in the rectum. (1 = Yes).
}
  \item{no_other_cause}{
Numeric (0 or 1). Have symptoms been active for at least 1 month and are NOT fully explained by another medical condition? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Infant Functional Constipation" or "Criteria Not Met".}
\item{Positive_Criteria_Count}{The number of positive criteria out of the five specified symptoms.}
}
\references{
Hyams JS, Di Lorenzo C, Saps M, et al. Functional Disorders: Children and Adolescents. Gastroenterology. 2016;150:1456-1468. doi:10.1053/j.gastro.2016.02.015
}
\examples{

# Example 1: Diagnosis Met
# 2 stools/week (1), Hard stools (1), Straining (1), No other features, No other cause
# Score = 3 (Meets criteria for 2 or more)
rome_iv_infant_functional_constipation(1, 1, 1, 0, 0, 1)

# Example 2: Not Met (Insufficient criteria)
# 4 stools/week (0), Hard stools (1), Straining (0)
# Score = 1 (Does not meet required 2 criteria)
rome_iv_infant_functional_constipation(0, 1, 0, 0, 0, 1)
}
