\name{rome_iv_infant_regurgitation}
\alias{rome_iv_infant_regurgitation}
\title{
Rome IV Diagnostic Criteria for Infant Regurgitation
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Infant Regurgitation** (Gastroesophageal Reflux, or "Spitting Up"). This is a functional disorder common in healthy infants, characterized by frequent episodes of regurgitation that are not associated with pain, aspiration, or failure to thrive.
}
\usage{
rome_iv_infant_regurgitation(age_lt_12mo, regurgitation_ge_2_day,
                              no_retching_hematemesis_etc, other_illness_excluded,
                              symptom_onset_ge_3_weeks, symptoms_active_last_2_weeks)
}
\arguments{
  \item{age_lt_12mo}{
Numeric (0 or 1). Is the infant between 3 weeks and **12 months of age**? (1 = Yes).
}
  \item{regurgitation_ge_2_day}{
Numeric (0 or 1). Does the infant regurgitate **two or more times per day**? (1 = Yes).
}
  \item{no_retching_hematemesis_etc}{
Numeric (0 or 1). Is there **NO** evidence of retching, hematemesis, aspiration, apnea, failure to thrive, or difficult swallowing? (1 = Yes). This excludes Gastroesophageal Reflux Disease (GERD).
}
  \item{other_illness_excluded}{
Numeric (0 or 1). Is there **NO** other organic illness or explanation for the symptoms? (1 = Yes).
}
  \item{symptom_onset_ge_3_weeks}{
Numeric (0 or 1). Did symptoms onset at least **3 weeks ago**? (1 = Yes).
}
  \item{symptoms_active_last_2_weeks}{
Numeric (0 or 1). Have symptoms been active for the last **2 weeks**? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Infant Regurgitation" or "Criteria Not Met".}
}
\references{
Hyams JS, Di Lorenzo C, Saps M, et al. Functional Disorders: Children and Adolescents. Gastroenterology. 2016;150:1456-1468. doi:10.1053/j.gastro.2016.02.015
}
\examples{

# Example 1: Diagnosis Met (Physiological Reflux)
# Age 6mo, Regurgitates 3x/day, No choking/poor growth, Chronic duration
rome_iv_infant_regurgitation(1, 1, 1, 1, 1, 1)

# Example 2: Not Met (Alarm Symptoms Present - Possible GERD)
# Regurgitates frequently, but is also having difficulty
#swallowing (0 for no_retching_hematemesis_etc)
rome_iv_infant_regurgitation(1, 1, 0, 1, 1, 1)
}
