\name{score_4at}
\alias{score_4at}
\title{
4AT: 4-Test Delirium Assessment
}
\description{
Calculates the 4AT score to screen for delirium and cognitive impairment. The 4AT is a rapid (<2 min) validated tool used in clinical settings. It assesses Alertness, the AMT4 (Abbreviated Mental Test - 4), Attention (Months Backwards), and Acute Change.
}
\usage{
score_4at(alertness, amt4_mistakes, attention_months, acute_change)
}
\arguments{
  \item{alertness}{
Numeric.
0 = Normal (fully alert, not agitated).
1 = Mild sleepiness for < 10 seconds after waking, then normal.
2 = Clearly abnormal (markedly drowsy or agitated).
(Note: Scores 0 or 1 result in 0 points; Score 2 results in 4 points).
}
  \item{amt4_mistakes}{
Numeric. Number of mistakes on the AMT4 (Age, Date of Birth, Place, Current Year).
0 = No mistakes (0 points).
1 = 1 mistake (1 point).
2 = 2 or more mistakes or Untestable (2 points).
}
  \item{attention_months}{
Numeric. Performance on "Months of the year backwards".
0 = Achieves 7 months or more correctly (0 points).
1 = Starts but scores < 7 months / refuses (1 point).
2 = Untestable (cannot start due to unwell/drowsy/inattentive) (2 points).
}
  \item{acute_change}{
Numeric. Evidence of significant change or fluctuation in mental status.
0 = No (0 points).
1 = Yes (4 points).
}
}
\value{
A list containing:
\item{Total_Score}{Sum of the component scores (Range 0-12).}
\item{Interpretation}{Clinical interpretation: "Delirium unlikely" (0), "Possible cognitive impairment" (1-3), or "Possible delirium" (4+).}
\item{Item_Breakdown}{Individual scores for each of the 4 items.}
}
\references{
Bellelli G, et al. Validation of the 4AT, a new instrument for rapid delirium screening: a study in 234 hospitalised older people. Age Ageing. 2014;43(4):496-502. doi:10.1093/ageing/afu021
}
\examples{

# Example 1: Possible Delirium
# Clearly abnormal alertness (Score 4), Untestable AMT4 (Score 2),
# Untestable Attention (Score 2), Acute Change Yes (Score 4) -> Total 12
score_4at(2, 2, 2, 1)

# Example 2: Normal
# Fully alert, 0 mistakes, >7 months correct, No acute change -> Total 0
score_4at(0, 0, 0, 0)

# Example 3: Possible Cognitive Impairment
# Alert, 1 mistake on AMT4, Refuses attention test, No acute change -> Total 2
score_4at(0, 1, 1, 0)
}
