\name{simon_broome_fh_criteria}
\alias{simon_broome_fh_criteria}
\title{
Simon Broome Diagnostic Criteria for Familial Hypercholesterolemia (FH)
}
\description{
Evaluates the Simon Broome criteria to diagnose Familial Hypercholesterolemia (FH). The diagnosis is based on elevated cholesterol levels combined with physical signs (xanthomas), family history, or DNA evidence. A diagnosis can be "Definite FH" or "Possible FH".
}
\usage{
simon_broome_fh_criteria(adult, total_cholesterol, ldl_cholesterol,
                         tendinous_xanthoma, fh_premature_chd,
                         fh_hypercholesterolemia, dna_mutation, units = "mg/dL")
}
\arguments{
  \item{adult}{
Numeric (0 or 1). Is the patient an adult (age > 16)? (1 = Yes).
}
  \item{total_cholesterol}{
Numeric. Total cholesterol level.
}
  \item{ldl_cholesterol}{
Numeric. LDL cholesterol level.
}
  \item{tendinous_xanthoma}{
Numeric (0 or 1). Presence of tendinous xanthoma in the patient or a 1st/2nd degree relative. (1 = Yes).
}
  \item{fh_premature_chd}{
Numeric (0 or 1). Family history of myocardial infarction (MI) at age < 60 in 1st degree relative or < 50 in 2nd degree relative. (1 = Yes).
}
  \item{fh_hypercholesterolemia}{
Numeric (0 or 1). Family history of elevated cholesterol (> 7.5 mmol/L) in 1st/2nd degree relative. (1 = Yes).
}
  \item{dna_mutation}{
Numeric (0 or 1). Evidence of a functional mutation in LDLR, APOB, or PCSK9 gene. (1 = Yes).
}
  \item{units}{
String. Units for cholesterol input. Options: "mg/dL" (default) or "mmol/L".
}
}
\details{
\strong{Cholesterol Thresholds:}
- Adult: Total Cholesterol > 7.5 mmol/L (290 mg/dL) or LDL > 4.9 mmol/L (190 mg/dL)
- Child: Total Cholesterol > 6.7 mmol/L (260 mg/dL) or LDL > 4.0 mmol/L (155 mg/dL)

\strong{Diagnosis:}
- \strong{Definite FH}: Cholesterol threshold met PLUS (Tendinous xanthoma OR DNA mutation).
- \strong{Possible FH}: Cholesterol threshold met PLUS (Family Hx of premature CHD OR Family Hx of hypercholesterolemia).
}
\value{
A list containing:
\item{Diagnosis}{The diagnostic classification (Definite FH, Possible FH, or Unlikely FH).}
\item{Cholesterol_Met}{Boolean indicating if the cholesterol threshold was met.}
}
\references{
Scientific Steering Committee on behalf of the Simon Broome Register Group. Risk of fatal coronary heart disease in familial hypercholesterolaemia. BMJ. 1991;303(6807):893-896.
}
\examples{

# Example 1: Definite FH (Adult)
# LDL 200 mg/dL (>190), Xanthoma present
simon_broome_fh_criteria(1, 300, 200, 1, 0, 0, 0)

# Example 2: Possible FH (Child)
# LDL 160 mg/dL (>155), Family Hx of high chol
simon_broome_fh_criteria(0, 270, 160, 0, 0, 1, 0)
}
